#!/usr/bin/perl

# expects hmds.dat & hmds.dat.hong in /tmp - generates /tmp/dat-file-diffs.txt

use strict;
use warnings;

use IO::All;
use Data::Dumper;

my (%hong, %test);

{ # create hash table of labno+sample_type => data for HONG data:
	my @ref = io('/tmp/hmds.dat.hong')->slurp; # warn Dumper \@ref; exit;
	%hong = map {
		chomp;
		my @data = split '\|';
		"$data[1]~$data[11]" => \@data;
	} @ref; # warn Dumper %hong;
}

{ # do same for test data:
	my @ref = io('/tmp/hmds.dat')->slurp; # warn Dumper \@ref; exit;
	%test = map {
		chomp;
		my @data = split '\|';
		"$data[1]~$data[11]" => \@data;
	} @ref; # warn Dumper %test;
}

# compare %test & %hong
open my $fh, '>' . '/tmp/dat-file-diffs.txt' or die $!;

while ( my ($ref,$data) = each %hong ) {
	my @test = @{ $test{$ref} };
	my @hong = @$data;
   
	next if ( join '~', @test ) eq ( join '~', @hong );
	
	# http://perldoc.perl.org/perlfaq4.html#How-do-I-compute-the-difference-of-two-arrays
	my @union = my @intersection = my @difference = ();
	my %count = ();
	foreach my $element (@hong, @test) { $count{$element}++ }
	foreach my $element (keys %count) {
		push @union, $element;
		push @{ $count{$element} > 1 ? \@intersection : \@difference }, $element;
   }
   
   print $fh $ref, ":\n";
   print $fh Dumper \@difference;
}