#!/usr/bin/perl

# rotates sql.log, debug.log, sql.txt, trace.log
# skips empty files using io($file)->size
# run from cron once per day eg 00:00

use strict;
use warnings;

use lib '/home/raj/perl5/lib/perl5';

use IO::All;
use Logfile::Rotate;

my $PATH_TO_LOGS = '/home/raj/www/apps/HMDS/trunk/logs';
my $archive = "$PATH_TO_LOGS/old";

#----------------------------------------------------------------------
my $sql_log = "$PATH_TO_LOGS/sql.log";

if ( io($sql_log)->size ) {
    Logfile::Rotate->new(
        File    => $sql_log,        # base filename
        Dir     => $archive,        # move old files to here
        Count   => 365,             # how many to keep before overwriting
        Gzip    => 'lib',           # use Compress::Zlib for compression (recommended)
        Flock   => 'yes',           # flock if supported
        Persist => 'yes',           # copy current logfile chown settings to any new log files
    )->rotate;
}

#----------------------------------------------------------------------
my $debug_file = "$PATH_TO_LOGS/debug.log"; #

if ( io($debug_file)->size ) {
    Logfile::Rotate->new(
        File    => $debug_file,   # base filename
        Count   => 3,             # how many to keep before overwriting
        Flock   => 'yes',         # flock if supported
        Persist => 'yes',         # copy current logfile chown settings to any new log files
    )->rotate;
}

#----------------------------------------------------------------------
my $sql_file = "$PATH_TO_LOGS/sql.txt";

if ( io($sql_file)->size ) {
    Logfile::Rotate->new(
        File    => $sql_file,     # base filename
        Count   => 1,             # how many to keep before overwriting
        Flock   => 'yes',         # flock if supported
        Persist => 'yes',         # copy current logfile chown settings to any new log files
    )->rotate;
}

#----------------------------------------------------------------------
my $dbi_trace = "$PATH_TO_LOGS/trace.log";

if ( io($dbi_trace)->size ) {
    Logfile::Rotate->new(
        File    => $dbi_trace,    # base filename
        Dir     => $archive,      # move old files to here
        Count   => 365,           # how many to keep before overwriting
        Flock   => 'yes',         # flock if supported
        Persist => 'yes',         # copy current logfile chown settings to any new log files
    )->rotate;
}