package LIMS::DB::Outreach::QuestionnaireDetail;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_details',
    
    columns => [
        request_id => { type => 'integer', not_null => 1 },
        field_id   => { type => 'integer', not_null => 1 },
        details    => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
        field => {
            class       => 'LIMS::DB::Outreach::QuestionnaireDetailField',
            key_columns => { field_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('questionnaire_details');

1;
