use Rose::DB::Object::Loader;

BEGIN {
	use FindBin qw($Bin);
	use lib "$Bin/../lib";
	# set database manually in rosedb_devinit_devel to change eg outreach/hmrn
	$ENV{ROSEDB_DEVINIT} = "$Bin/../config/rosedb_devinit_devel.pl"; # overrides default db test
}

use strict;
use LIMS::DB;
use Data::Dumper;

my $loader =
    Rose::DB::Object::Loader->new(
        db => LIMS::DB->new,
        class_prefix => 'LIMS',
        with_managers => 0,
    );

# print $Bin; exit;

open my $fh, '>', "$Bin/../setup/schema/classes.pl" or die $!;
print $fh "# generated automatically by script/make_classes.pl\n\n";

my $delimiter = '#' . ('-' x 75);

my @classes = $loader->make_classes( pre_init_hook => \&delete_all_empty_string_defs );

foreach my $class (sort @classes) { print $class, "\n";
	print $fh $delimiter, "\n";
    if ( $class->isa('Rose::DB::Object') ) {
        print $fh $class->meta->perl_class_definition(
        #    braces => 'bsd',
            indent => 4,
        ), "\n";
    }
    else {# Rose::DB::Object::Manager subclasses
        print $fh $class->perl_class_definition, "\n";
    }
}

# TODO: walk over the list of columns for each class, eliminating all the empty string default values (i.e., changing them to undef instead) - Rose/DB/Object/Loader.pm#GOTCHAS
sub delete_all_empty_string_defs {
    my $meta_data = shift; return;

    my $cols = $meta_data->columns;
    # warn Dumper $cols;
}