package Anonymise::LIMS;

use Moose;
extends 'AnonymisePatient';

use Data::Random qw(:all);

has path_to_app => ( is  => 'ro', isa => 'Str', required => 1 );
	
# replaces some $vals entries - doesn't return anything:
sub anonymise_patient {
	my $self = shift;
	my $vals = shift;

    my $substitute = $self->get_substitutes;

    my @last_names  = @{ $substitute->{last_names  } };
    my @first_names = @{ $substitute->{first_names } };
    my @boys_names  = @{ $substitute->{male_names  } };
    my @girls_names = @{ $substitute->{female_names} };

	my $first_name = '';
	my $gender = $vals->{gender} || '';

	if ($gender eq 'M') {
		$first_name = $boys_names[rand @boys_names];
	}
	elsif ($gender eq 'F') {
		$first_name = $girls_names[rand @girls_names];
	}
	else {
		$first_name = $first_names[rand @first_names];
	}

	# replace these $vals entries:
	$vals->{last_name}  = lc $last_names[rand @last_names];
	$vals->{first_name} = lc $first_name;
    if ( $vals->{dob} ) { # Data::Random::rand_date
        $vals->{dob} = rand_date(min => '1920-1-1', max => '2000-1-1');
    }
    if ( $vals->{nhs_number} ) {
        # needs to be unique
        $vals->{nhs_number} = $self->make_nhsno;
    }
}

1;
