#
#===============================================================================
#
#  DESCRIPTION: Interface to send RFCs to Issues board
#  uses plugins
#  implemented Trello plugin via LIMS::Local::IssueTracker::Plugin::Trello
#  future plugin ideas: GitLab?
#
#===============================================================================
package LIMS::Local::IssueTracker;

our $VERSION = "0.01";
use Modern::Perl;
use utf8;
use Carp;
use YAML::Tiny;

use FindBin qw($RealBin);    # warn $RealBin;
use lib $RealBin . '../lib';
use LIMS::Local::Config;
use LIMS::Local::Utils;
use LIMS::Local::ScriptHelpers;
use Data::Printer;

use Moose;
use namespace::autoclean;

has 'config_file' => (
    is      => 'ro',
    isa     => 'Str',
    default => 'issue_tracking',
);

has 'config' => (
    is      => 'ro',
    isa     => 'HashRef',
    builder => '_build_config',
    lazy    => '1'
);

with 'MooseX::Object::Pluggable';

sub _build_config {
    my ($self) = @_;
    my $yaml;
    # testing requires yaml files from any location
    if ( -e $self->config_file ){ # overriding default config locations
        $yaml = YAML::Tiny->read( $self->config_file )->[0];
    }
    else {
        my $config = LIMS::Local::Config->instance;
        my $tools  = LIMS::Local::ScriptHelpers->new;
        my ($top_level_hilis) = $RealBin =~ /^(.*apps\/HILIS4)/;
        $tools->use_path($top_level_hilis);
        $yaml = $tools->get_yaml_file( $self->config_file );
    }    
# dont use the live Trello board while testing
    if ( $ENV{HARNESS_ACTIVE} || $ENV{TESTRUN} )
    {
        $yaml->{board} = $yaml->{board}->{test};
    }
    else {
        $yaml->{board} = $yaml->{board}->{live};
    }
    return $yaml;
}

sub BUILD {
    my $self = shift;
    $self->load_plugin( $self->config->{plugin} );  # config needs to load first
    croak "not trackable" unless $self->does("LIMS::Local::Role::Trackable");
    $self->check_config()
      or croak $self->config->{plugin} . " config error: " . $!;
}

__PACKAGE__->meta->make_immutable;

1;
