package LIMS::DB::ResultSummaryExpansion;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'result_summary_expansion',

    columns => [
        result_summary_option_id => { type => 'integer', not_null => 1 },
        description              => { type => 'text', not_null => 1 },
        is_active                => { type => 'enum',
            check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'result_summary_option_id' ],

    foreign_keys => [
        result_summary_option => {
            class       => 'LIMS::DB::ResultSummaryOption',
            key_columns => { result_summary_option_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('result_summary_expansions');

1;
