#!/usr/bin/perl

=begin -------------------------------------------------------------------------
generates list of Gallium trial requests which are not ready for data transfer,
where ICDO3 is null and diagnosis NOT one of: 'no evidence of lymphoma',
'unsuitable specimen', 'inadequate sample'
=cut ---------------------------------------------------------------------------

use strict;
use warnings;

my $JUST_TESTING = 0; # email to ra.jones only

use lib '/home/raj/perl5/lib/perl5';
use Data::Dumper;

use FindBin qw($Bin); # warn $Bin;
use lib $Bin . '/../../../lib';
use LIMS::Local::ScriptHelpers;

my $tools = LIMS::Local::ScriptHelpers->new();
$tools->test_only($JUST_TESTING);

############ recipients from contacts.lib ######################################
my @recipients = qw( raj andrew.jack lynda.blythe.secure ); # archana.ambily
################################################################################

# get tools from LIMS::Local::ScriptHelpers:
my $sql_lib = $tools->sql_lib();
my $config  = $tools->config(); 
my $dbix    = $tools->dbix();

my $cfg_file = "$Bin/../lib/settings.cfg";
my $settings = Config::Auto::parse($cfg_file); # warn Dumper $settings; exit;

# permitted non-ICDO3 diagnoses:
my $non_icdo3 = $settings->{non_icdo3}; # warn Dumper $non_icdo3;
push @$non_icdo3, 'Not required';

# email subject line:
my $subject = 'Gallium trial diagnoses pending';

my $sql = $sql_lib->retr('gallium_pending'); # warn $sql;
my $rows = $dbix->query($sql, @$non_icdo3)->arrays; # warn Dumper $rows;

exit unless @$rows;

# flag to Local::Mail::_verify_service_status() that msg safe to send:
$config->{_safe_message} = 1 if ! $config->{is_in_production_mode};

my $message_body
    = $tools->process_template('cron/gallium_pending.tt', { data => $rows }); # warn $message_body;

my %mail = (		
    subject => $subject,
    message => $message_body,
    content => 'html',
	config  => $config,
); # warn Dumper \%mail; exit;

$tools->send_mail(\%mail, \@recipients);
