package LIMS::DB::RequestLabSectionForeignID;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_lab_section_foreign_id',

    columns => [
        request_id     => { type => 'integer', not_null => 1 },
        lab_section_id => { type => 'integer', not_null => 1 },
        foreign_id     => { type => 'varchar', length => 25, not_null => 1 },
        time           => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::DB::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_lab_section_foreign_ids');

1;