package LIMS::DB::RequestDraftReport;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'request_draft_report',

    columns => [
        user_id                => { type => 'integer', not_null => 1 },
        request_id             => { type => 'integer', not_null => 1 },
        request_notes          => { type => 'text', length => 65535 },
        clinical_details       => { type => 'text', length => 65535 },
        biopsy_site            => { type => 'varchar', length => 255 },
        gross_description      => { type => 'varchar', length => 255 },
        morphology             => { type => 'text', length => 65535 },
        comment                => { type => 'text', length => 65535 },
        status                 => {
            type        => 'enum',
            check_in    => [ qw(new relapse default) ], 
			default     => 'default',
            not_null    => 1,
        },
        diagnosis_id           => { type => 'integer', not_null => 1 },
        secondary_diagnosis_id => { type => 'integer' },
        specimen_quality       => {
            type        => 'enum',
            check_in    => [ qw(good adequate poor) ], 
			default     => 'adequate',
        },
        created_at             => { type => 'timestamp', not_null => 1 },
        updated_at             => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'user_id' ],

    foreign_keys => [
        user => {
            class       => 'LIMS::DB::User',
            key_columns => { user_id => 'id' },
        },

        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
        },
        
        diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { diagnosis_id => 'id' },
        },
        
        secondary_diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { secondary_diagnosis_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_draft_reports');

1;