use DateTime;
use Digest::SHA1 'sha1_base64';

# CHANGES HERE NEED TO BE MIRRORED IN constraints.t

$TEST_DATA = {
    additional_options => {
        fields => [ qw(option_name option_label is_active) ],
        values => [
            [ qw( urgent Urgent yes ) ],
            [ qw( doi DoI yes ) ],
        ]
    },
    audit_request_categories => {
        fields => [ 'description' ],
        values => [
            [ 'cytopenia' ],
        ],
    },
    audit_request_options => {
        fields => [ qw(description category_id) ],
        values => [
            [ 'Anaemia', 1 ],
        ],
    },
    clinical_trials => {
        fields => [ qw(trial_name active) ],
        values => [
            [ 'NCRI: Myeloma X', 'yes' ],
            [ 'HMDS outreach',   'yes' ],
        ],
    },
    consent_options => {
        fields => [ qw(consent_name consent_label is_active) ],
        values => [
            [ qw( treatment Treatment yes ) ],
            [ qw( research  Research  yes ) ],
        ]
    },
    diagnoses => {
        fields => [ qw(name icdo3 diagnostic_category_id active) ],
        values => [
            [ qw( RAEB 9983/3 1 yes ) ],
            [ qw( CLL  9823/3 2 yes ) ],
        ],
    },
    diagnosis_change_options => {
        fields => [ qw( option_name description is_active ) ],
        values => [
            [ qw(error error yes) ],
            [ qw(update update yes) ]
        ],
    },
    diagnostic_categories => {
        fields => [ qw(description category_type active) ],
        values => [
            [ qw(Myelodysplastic main yes) ],
            [ qw(Lymphoproliferative main yes) ],
            [ qw(Non-diagnostic main yes) ],
        ],
    },
    email_addresses => {
        fields => [ 'address' ],
        values => [
            [ 'user@anywhere.net' ],
        ],
    },
    error_codes => {
        fields => [ qw(code description is_unique active) ],
        values => [
            [ qw(a first_error  yes yes) ],
            [ qw(b second_error no  yes) ],
            [ qw(c third_error  yes yes) ],
        ],
    },
    error_code_assignment => {
        fields => [ qw(type error_code_id) ],
        values => [
            [ qw(new_request 1) ],
            [ qw(patient 1) ],
            [ qw(errors  2) ],
            [ qw(errors  3) ],
        ],
    },
    hospital_departments => {
        fields => [ qw(id display_name) ],
        values => [
            [ 100, 'General Surgery'  ],
            [ 600, 'General Medical Practice' ],
            [ 823, 'Haematology'      ],
            [ 999, 'Unknown/other'    ],
        ],
    },
    lab_section_sample_type => {
        fields => [ qw(lab_section_id sample_type_id) ],
        values => [
           [ 1, 1 ], # Flow / liquid
           [ 2, 2 ], # Histology / biopsy
           [ 3, 1 ], # Molecular / liquid
           [ 3, 2 ], # Molecular / biopsy
        ],
    },
    lab_section_status_option => {
        fields => [ qw(lab_section_id status_option_id) ],
        values => [
            [ 1, 4 ],
        ],
    },
    lab_sections => {
        fields => [ 'section_name', 'has_result_summary', 'has_section_notes',
            'has_test_sign_out', 'has_foreign_id', 'has_results_import', 'is_active' ],
        values => [
            [ qw(Flow      yes yes  no yes  no yes) ],
            [ qw(Histology yes yes yes  no  no yes) ],
            [ qw(Molecular yes  no yes  no yes yes) ],
        ],
    },
    lab_test_data_type => {
        fields => [ qw(lab_test_id data_type_id is_active ) ],
        values => [
            [ 6, 2, 'yes' ],
            [ 7, 2, 'yes' ],
            [ 8, 1, 'yes' ],
        ]
    },
    lab_test_result_data_types => {
        fields => [ 'description' ],
        values => [
            [ 'numeric' ], [ 'subjective' ], [ 'text' ],
        ],
    },
    lab_test_result_options => {
        fields => [ qw(data_type_id value is_active) ],
        values => [
            [ 1,  0,    'yes' ],
            [ 1, 10,    'yes' ],
            [ 1, 50,    'yes' ],
            [ 2, '+',   'yes' ],
            [ 2, '-',   'yes' ],
            [ 2, '+/-', 'yes' ],
        ],
    },
    lab_test_status_options => {
        fields => [ 'description', 'is_active' ],
        values => [
            [ 'new',      'yes' ],
            [ 'complete', 'yes' ],
            [ 'delete',   'yes' ],
            [ 'setup',    'yes' ],
        ],
    },
    lab_tests => {
        fields => [
            qw(field_label test_name lab_section_id test_type has_results is_active)
        ],
        values => [
            [ qw(PNH  pnh  1 panel  no yes) ],
            [ qw(AML  aml  1 panel  no yes) ],
            [ qw(CML  cml  1 panel  no yes) ],
            [ qw(HIV  hiv  1 panel  no yes) ],
            [ qw(APML apml 3 panel  no yes) ],
            [ qw(CD20 cd20 2  test yes yes) ],
            [ qw(p53  p53  2  test yes yes) ],
            [ qw(Mib1 mib1 2  test yes yes) ],
            [ qw(AUTO auto 2  test yes yes) ], # auto-requested by sample type  
        ],
    },
    local_network_locations => {
        fields => [ 'parent_id' ],
        values => [ [1] ], # any org code will do
    },
    parent_organisations => {
        fields => [ qw(parent_code description referral_type_id) ],
        values => [
            [ 'ABC',    'NEWTOWN NHS TRUST',    3 ],
            [ 'B12345', 'OLD SURGERY, NT1 1TN', 4 ],
            [ 'X99999', 'UNKNOWN HOSPITAL',     3 ],
            [ 'V81999', 'UNKNOWN PRACTICE',     4 ],
        ],
    },
    patients => {
        fields => [ qw(last_name first_name dob gender nhs_number created_at) ],
        values => [
            [ qw(green alan 1940-02-01 M 1111111111), DateTime->now() ],
            [ qw(brown stan 1960-10-04 M 2222222222), DateTime->now() ],
        ],
    },
    patient_case => {
        fields => [ qw(patient_id referral_source_id unit_number) ],
        values => [
            [ 1, 2, 1011 ], # gp surgery referral
            [ 2, 1, 1234 ], # hospital referral
        ],
    },
    phone_log_options => {
        fields => [ qw(description is_active) ],
        values => [
            [ 'final diagnosis given', 'yes' ],
            [ 'request report copy',   'yes' ],
        ],
    },
    referral_types => {
        fields => [ qw( description prefix default_unknown ) ],
        values => [
            [ qw( clinician    C C9999998 ) ],
            [ qw( practitioner G G9999998 ) ],
            [ 'hospital', undef, 'X99999'   ],
            [ 'practice', undef, 'V81999'   ],
        ],
    },
    referrers => {
        fields => [ qw(name national_code referral_type_id) ],
        values => [
            [ 'Brown CC', 'C1234567', 1 ],
            [ 'Black DE', 'G1234567', 2 ],
            [ 'Cutter S', 'C7654321', 1 ],
            [ 'Unknown',   'C9999998', 1 ],
            [ 'Unknown',   'G9999998', 2 ],
        ],
    },
    referral_sources => {
        fields => [ qw( display_name organisation_code parent_organisation_id
            referral_type_id ) ],
        values => [
            [ 'Newtown General Infirmary',     'ABC01',  1, 3 ],
            [ 'The Surgery, Newtown, NT1 1NT', 'B12345', 2, 4 ],
            [ 'Unknown hospital',              'X99999', 3, 3 ],
            [ 'Unknown practice',              'V81999', 4, 4 ],
        ],
    },
    referrer_department => {
        fields => [ qw(referrer_id parent_organisation_id hospital_department_code) ],
        values => [
            [ 1, 1, 823 ],
            [ 2, 2, 600 ],
            [ 3, 1, 100 ],
            [ 4, 3, 999 ],
            [ 5, 4, 600 ],
        ],
    },
    requests => {
        fields => [ qw(year request_number patient_case_id referrer_department_id created_at) ],
        values => [
            [ DateTime->now->year, 1, 1, 2, DateTime->now ], # gp surgery referral
            [ DateTime->now->year, 2, 2, 1, DateTime->now ], # hospital referral
        ],
    },
    request_consent => {
        fields => [ qw( request_id consent_id status ) ],
        values => [
            [ 1, 1, 'yes' ],
        ]
    },
    request_specimen => {
        fields => [ qw(request_id specimen_id) ],
        values => [
            [ 1, 1 ],
            [ 1, 4 ],
            [ 2, 2 ],
        ],
    },
    request_trial => {
        fields => [ qw(request_id trial_id) ],
        values => [
            [ 1, 1 ],
        ],
    },
    result_summary_options => {
        fields => [ qw(description lab_section_id is_active ) ],
        values => [
            [ 'Normal', 1, 'yes' ],
        ]
    },
    sample_types => {
        fields => [ 'specimen_type' ],
        values => [
            [ 'liquid' ],
            [ 'biopsy' ],
        ],
    },
    screen_category => {
        fields => [ 'name' ],
        values => [
            [ 'fresh' ],
            [ 'fixed' ],
        ],
    },
    screens => {
        fields => [ qw(description category_id active) ],
        values => [
            [ qw(AML 1 yes) ],
            [ qw(PNH 1 yes) ],
        ],
    },
    screen_lab_test => {
        fields => [ qw(screen_id lab_test_id) ],
        values => [
            [ 1, 2 ], # AML / AML (Flow)
            [ 1, 5 ], # AML / APML (Molecular)
            [ 2, 1 ], # PNH / PNH (Flow)
        ]
    },
    screen_lab_test_detail => {
        fields => [ qw(screen_id lab_section_id test_details) ],
        values => [
            [ 1, 1, 'AML partial panel' ], 
        ]
    },
    specimen_lab_test => {
        fields => [ 'specimen_id', 'lab_test_id' ],
        values => [
            [ 4, 9 ], # specimen BMAT auto-requests test 'AUTO'
        ],
    },
    specimens => {
        fields => [ qw(sample_code description active) ],
        values => [
            [ 'PB',   'peripheral blood', 'yes'     ],
            [ 'LU',   'lymph node, unfixed', 'yes'  ],
            [ 'BMA',  'bone marrow aspirate', 'yes' ],
            [ 'BMAT', 'bone marrow aspirate & trephine', 'yes' ],
        ],
    },
    specimen_sample_type => {
        fields => [ qw(specimen_id sample_type_id) ],
        values => [
            [ 1, 1 ], # PB / liquid
            [ 2, 1 ], # LU / liquid
            [ 3, 1 ], # BMA / liquid
            [ 4, 1 ], # BMAT / liquid
            [ 4, 2 ], # BMAT / biopsy
        ],
    },
    status_options => {
        fields => [ qw( description is_editable is_active ) ],
        values => [
            [ 'new',        'yes', 'yes', ],
            [ 'screened',   'yes', 'yes', ],
            [ 'reported',   'yes', 'yes', ],
            [ 'authorised', 'yes', 'yes', ],
            [ 'complete',   'yes', 'yes', ],
            [ 'deleted',    'yes', 'yes', ],
        ]
    },
    user_functions => {
        fields => [ qw(function_name function_detail active) ],
        values => [
            [ 'search',         'search for requests',  'yes' ],
            [ 'view_history',   'view request history', 'yes' ],
            [ 'print_one',      'print a record',       'yes' ],
            [ 'register',       'register requests',    'yes' ],
            [ 'edit_pid',       'edit patient',         'yes' ],
            [ 'modify_results', 'modify results',       'yes' ],
            [ 'screen',         'screen requests',      'yes' ],
            [ 'report',         'report requests',      'yes' ],
            [ 'do_admin',       'admin functions',      'yes' ],
            [ 'phone_log',      'view/edit phone log',  'yes' ],
            [ 'log_errors',     'log errors',           'yes' ],
            [ 'delete_record',  'delete requests',      'yes' ],
            [ 'patient_merge',  'merge patients',       'yes' ],
            [ 'view_unrestricted', 'view unauthorised entries', 'yes' ],
        ],
    },
    user_groups => {
        fields => [ qw(group_name group_label group_detail active) ],
        values => [
            [ 'su',    'SuperUser', 'superuser description', 'yes' ],
            [ 'guest', 'Guest',     'guest description',     'yes' ],
            [ 'bms',   'BMS',       'bms description',       'yes' ],
        ],
    },
    user_group_function => {
        fields => [ 'group_id', 'function_id' ],
        values => [
            # group_id #1 needs all functions for test-script user:
            ( map { [ 1, $_ ] } (1..14) ),
            
            # guest:
            [ 2, 1 ], # search
            [ 2, 2 ], # view history
            [ 2, 3 ], # print record
            
            # bms:
            [ 3, 1 ], # search
            [ 3, 2 ], # view history
            [ 3, 3 ], # print record
            [ 3, 4 ], # register
        ],
    },
    user_locations => {
        fields => [ qw(location_name region_code active) ],
        values => [
            [  qw(HMDS ABC yes) ],
        ],
    },
    users => {
        fields => [ qw( username last_name first_name email user_location_id
            designation group_id active password ) ],
        values => [
            [ qw(admin admin_lname admin_fname admin@here.com 1 administrator 1 yes ),
                Digest::SHA1::sha1_base64('adm1n')],
        ]
    }
};
