package LIMS::Model::Test;

use Moose;
with (
	'LIMS::Model::Roles::DBIxSimple',
);
extends 'LIMS::Model::Base';
use namespace::clean -except => 'meta';
__PACKAGE__->meta->make_immutable;

use Data::Dumper;

#-------------------------------------------------------------------------------
sub get_all_diagnoses {
    my $self = shift;

    my %args = (
        sort_by => 'name',
        require_objects => 'diagnostic_category',
        limit => 5,
    );

    my $data = LIMS::DB::Diagnosis::Manager->get_diagnosiss(%args); # DEBUG $data;

    return $data;
}

# experimental method using DBIx::Simple - too slow with CONCAT in sql
sub get_request_and_patient_data_from_labno {
    my ($self, $labnos) = @_; # warn Dumper $labnos;
    
    my $dbix = $self->lims_dbix;
    
    my $sql = q!
        select r.id, p.last_name from requests r join patient_case pc on
        r.patient_case_id = pc.id join patients p on pc.patient_id = p.id
        where concat('H', r.request_number, '/', r.year - 2000) in (??)!;
        
    my $data = $dbix->query( $sql, @$labnos)->hashes; # warn Dumper $data;
    
    return $data;
}

sub db_read_timer {
    my $self = shift;
    my $cycles = shift || ''; # optional
    
    my $dbix = $self->lims_dbix;
    
    my $query = $dbix->query('select * from referrers');
    
    my $i = 0;
    ROW: while ( my $row = $query->hash ) {
        $i++; last ROW if $cycles && $i == $cycles;
    }
    return $i;
}

sub db_write_timer {
    my ($self, $cycles) = @_;
    
	$ENV{RDBO_DEBUG} = 0; # switch off or will get 10_000 entries in console!
    my $dbix = $self->lims_dbix;
    
    $dbix->dbh->do('drop table if exists lims_test.timer');
    # creates an InnoDB table - write performance slow on SuSE:
    $dbix->dbh->do('create table lims_test.timer like referrers');
    
    my $i = 0;
    for ( 1 .. $cycles ) {
        my %data = (
            name => 'Other AN', # doesn't need to be unique
            national_code => ( sprintf 'C%06d', ++$i ), # must be unique 
            referral_type_id => 1,
            active => 'yes',
        );
        $dbix->insert( 'lims_test.timer', \%data );
    }
    $dbix->dbh->do('drop table lims_test.timer');
    return $i;
}

sub db_read_write_timer {
    my ($self, $cycles) = @_;
    
	$ENV{RDBO_DEBUG} = 0; # switch off or will get 10_000 entries in console!
    my $dbix = $self->lims_dbix;
    # $dbix->keep_statements = 200; # reduces performance as n increases !!
    
    $dbix->dbh->do('drop table if exists lims_test.timer');
    $dbix->dbh->do('create table lims_test.timer like referrers');

    my $sql = 'select * from referrers';
    $sql .= qq! limit $cycles! if $cycles;
    
    my $i = 0;
    
#    my $all = $dbix->query($sql)->hashes; # all in one go ~ 1000 rows/sec    
    my $result = $dbix->query($sql); # one at a time ~ 750 rows/sec

#    for my $ref ( @$all ) { # warn Dumper $ref;
    while ( my $ref = $result->hash ) { 
        my %data = map +( $_ => $ref->{$_} ), grep $_ ne 'id', keys %$ref;
        $dbix->insert( 'lims_test.timer', \%data );
        $i++;
    }
    $dbix->dbh->do('drop table lims_test.timer');
    return $i;
}

sub db_status {
	my $self = shift;
	my $dbix = $self->lims_dbix;
	my $list = $dbix->query( 'SHOW PROCESSLIST' )->arrays;
	return $list;
}

1;
