#
#===============================================================================
#  DESCRIPTION: These tests are for creating different parameterized roles so
#  there are many test instances for LIMS::Local::Role::NotTestable to create
#  different 'NotTestables'
#===============================================================================
package TestsFor::LIMS::Local::Role::NotTestable::LiveTest;
use utf8;
use Test::Class::Moose;

use DDP;
use Try::Tiny;

sub class_name { 'LIMS::Local::Role::NotTestable';}

use FindBin qw($RealBin);
use LIMS::Local::Config;

my $config = LIMS::Local::Config->instance;
my $production_mode = $config->{settings}->{is_in_production_mode};
with(
     'LIMS::Local::Role::NotTestable' => {
        unsafe     => [qw/_unsafe1 _unsafe2/],
        production => 1,
        testing    => 1
    }
);

sub test_some {
    my $test  = shift;
    my $class = $test->test_class;
    ok("before run ok");

    note "LIVE TEST: p = 1, t = 1";
    warning_is { $class->_unsafe1(1, 2, 3) }  '_unsafe1() only runs in production mode' , 'warns that you can\'t run this code';
    {
# now run without warnings going to screen and merging with test output
        local $SIG{__WARN__} = sub {
            my $message = shift;
        };
        is($class->_unsafe1(1, 2, 3) , "testing1 1 2 3", "runs testing code");
        is($class->_unsafe2(1, 2, 3) , undef, "doesnt run and no substitute sub");
    }

}
sub _unsafe1 {
   my ($self, @args) = @_;
   return "unsafe @args";
}
sub _unsafe2 {
   my ($self, @args) = @_;
   return "unsafe @args";
}
sub _testing_unsafe1 {
   my ($self, @args) = @_;
   return "testing1 @args";
}
sub _dev_unsafe1 {
   my ($self, @args) = @_;
   return "dev1 @args";
}
1;
