package LIMS::Controller::Admin::Screen::Term;

use strict;

use base 'LIMS::Controller::Admin';

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my @sort_by = ('description');
    unshift @sort_by, $self->query->param('sort_by'); # only set if by sample_type

	my %args = ( sort_by => \@sort_by );

	if ( my $category_id = $self->query->param('category_id') ) {
		$args{category_id} = $category_id;
	}

    my $total = $self->model('Screen')->get_screening_terms_count(\%args);

	if ( $total > $self->cfg('settings')->{entries_per_page} ) {
        # invoke pager for template and add limit & offset params to \%args:
        $self->pager({ query => \%args, total => $total });
    }

    { # get list of screens table data:
        my $screens = $self->model('Screen')->get_all_screens(\%args);
    	$self->tt_params( screening_list => $screens );
    }
    { # get screening categories:
        my $args = { sort_by => 'name' };
        my $categories
            = $self->model('Base')->get_objects('ScreenCategory', $args);
		$self->tt_params( screen_categories => $categories );
    }
    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('screening_terms');

    return $self->tt_process($errs);
}

# ------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id')
        || return $self->error('no id passed to '.$self->get_current_runmode); # $self->debug('id:'.$id);

    my $screen = $self->model('Screen')->get_screen($id);
    $self->tt_params( data => $screen );

    { # get screening categories:
        my $categories = $self->model('Base')->get_objects('ScreenCategory');
		$self->tt_params( screen_categories => $categories );
    }

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('screening_terms');

    return $self->tt_process($errs);
}

# ------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	my $id = $self->param('id');
	
	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }
	
    # if param 'id' passed, return error to edit():
    my $error_rm = $self->param('id') ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('screening_terms') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('Screen')->update_screening_terms($data);

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/admin/screen_term' ); # safer to redirect after db edit
}

1;
