package LIMS::Controller::Roles::Dashboard;

use Moose::Role;
use Data::Dumper;

has dashboard_data => (
	is  	=> 'ro',
	isa 	=> 'HashRef',
	traits  => ['Hash'],
	default => sub { {} },
	handles => { set_dashboard_data => 'set' },
);

sub dashboard_view {
    my $self = shift;

    { # urgent
        my %args = ( status_query => 'urgent' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( urgent => $n );
    }
    { # unscreened
        my %args = ( status_query => 'unscreened' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unscreened => $n );
    }
    { # unreported
        my %args = (
            status_query => 'unreported',
            duration     => $self->cfg('settings')->{unreported_duration},
        ); # warn Dumper \%args;
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unreported => $n );
    }
    { # unreported, tests_completed
        my %args = ( status_query => 'tests_completed' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( tests_completed => $n );
    }
    { # unauthorised
        my %args = ( status_query => 'unauthorised' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( unauthorised => $n );
    }
    { # authorised incomplete
        my %args = ( status_query => 'incomplete' );
        my $n = $self->model('WorkList')->request_status_count(\%args);
        $self->set_dashboard_data( incomplete => $n );
    }
    { # incomplete lab-tests:
        my $data = $self->model('LabTest')->get_incomplete_lab_tests();
        $self->set_dashboard_data( incomplete_section_tests => $data );
    }
	{ # function to calculate totals from lab-test status entries:
		my $sub = sub {
			my $test = shift; # warn Dumper $test; # hashref of status => count
			my $i; $i += $test->{$_} for keys %$test; # warn $i;
			return $i;
		};
		$self->set_dashboard_data( sum_this => $sub );
	}
	{ # function to get all status values in use for lab-section:
		my $sub = sub {
			my $section = shift; # warn Dumper $section; # HoH
			my %h;
			while ( my ($test, $d) = each %$section ) { # $d is hashref of status => counts
				$h{$_}++ for keys %$d;
			} # warn Dumper [ keys %h ];
			return [ sort new_first keys %h ];
		};
		$self->set_dashboard_data( get_status_vals => $sub );
	}
}

# return 'new' as 1st entry (gets same chart colour), then ascii sort ($a cmp $b):
sub new_first { # warn Dumper [$a, $b];
	# http://www.perlfect.com/articles/sorting.shtml
	return $a eq 'new'
		? -1
		: $b eq 'new'
			? 1
			: lc $a cmp lc $b;
}

1;
