package LIMS::Controller::Admin::Config::EmailContacts;

use base 'LIMS::Base';
use LIMS::Local::Sugar;

use strict;
use warnings;

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# -------------------------------------------------------------------------------------
startmode default ($errs) {
    $self->_debug_path($self->get_current_runmode); # $self->stash(errs => $errs);

    my $email_contacts = $self->model('ReferralSource')->get_email_contacts;

	my $ref_srcs = $self->model('Base')->get_objects('ReferralSource');
	
    $self->tt_params(
		email_contacts => $email_contacts,
		ref_srcs       => $ref_srcs,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('email_contacts');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode edit ($errs, $id) {
    $self->_debug_path($self->get_current_runmode);

    $id || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('ReferralSource')->get_email_contact($id);
	my $ref_srcs = $self->model('Base')->get_objects('ReferralSource');

    $self->tt_params(
        ref_srcs => $ref_srcs,
		data => $data,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('email_contacts');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
runmode update ($id) {
    $self->_debug_path($self->get_current_runmode);

	# if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

    # referral_source_id only supplied on edit if 'location' changed, but
    # is a required field:
    unless ( $self->query->param('referral_source_id') ) {
        # add it from _referral_source_id hidden field for validation:
        my $referral_source_id = $self->query->param('_referral_source_id');
        $self->query->param( referral_source_id => $referral_source_id );
    }

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) {
        $self->query->param( _record_id => $id );
    }

	my $dfv = $self->check_rm($error_rm, $self->validate('email_contacts') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) {
		$data->{id} = $id;
	}

    my $rtn = $self->model('ReferralSource')->update_email_contacts($data); # warn $rtn;

    if ($rtn) {
        $self->error($rtn);
	}
	else {
		$self->flash( info => $self->messages('action')->{edit_success} );
        $self->redirect( $self->query->url . '/config/email-contacts' );
    }
}

1;