package LIMS::Controller::Admin::User::Function;

use strict;

use base 'LIMS::Controller::Admin';

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

#-------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    # get list of functions table data:
    my $functions
		= $self->model('User')->get_user_functions({sort_by => 'function_name'});

	$self->tt_params( functions => $functions );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('user_functions');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id')
        || return $self->error('no id passed to '.$self->get_current_runmode); # $self->debug('id:'.$id);

    my $function = $self->model('User')->get_user_function($id);

    $self->tt_params( function => $function );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('user_functions');

    return $self->tt_process($errs);
}

#-------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

	my $id = $self->param('id');
	
	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('user_functions') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
	|| return $self->forward('default'); # eg if empty param;

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('User')->update_user_functions($data);
	
    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/admin/user_function' ); # safer to redirect after db edit
}

1;