#!/usr/bin/perl

=begin -------------------------------------------------------------------------
sends a list of new teaching cases for previous 7 days
=cut ---------------------------------------------------------------------------

use strict;
use warnings;

my $JUST_TESTING = 0; # email to ra.jones only

#-------------------------------------------------------------------------------
my @recipients = qw(douglas sinclair bagguley raj); # for non-secure info
#-------------------------------------------------------------------------------

BEGIN {
    use FindBin qw($Bin); # warn $Bin;
    use lib (
        "$Bin/../../../lib",
        '/home/raj/perl5/lib/perl5',
    );
}

use Data::Dumper;
use LIMS::Local::ScriptHelpers;

my $tools = LIMS::Local::ScriptHelpers->new();
$tools->test_only($JUST_TESTING);

# get tools from LIMS::Local::ScriptHelpers:
my $sql_lib = $tools->sql_lib();
my $config  = $tools->config(); 
my $dbix    = $tools->dbix();

my $today = $tools->time_now();
my $query = $sql_lib->retr( 'teaching_cases' );

# email subject line:
my $subject = 'New teaching cases';
my $duration = 7; # days

my $rows = $dbix->query($query, $duration)->arrays; # warn Dumper $rows;

my $message_body = @$rows
	? $tools->process_template('cron/teaching_cases.tt', { data => $rows })
	: "No teaching cases found for past $duration days"; # warn $message_body;

my %mail = (		
    subject => $subject,
    message => $message_body,
    content => 'html',
	config  => $config,
); # warn Dumper \%mail;

$tools->send_mail(\%mail, \@recipients);
