#
#===============================================================================
#
#  DESCRIPTION: test all crons are executable except those in @stoplist
#
#===============================================================================

use Modern::Perl '2012';
use utf8;

use Test::More;    # last test to print
use Test::File;

use File::Spec::Functions 'catdir';
use File::Find;

my @stoplist = qw/
  billing_data_compare.pl
  hilis_convert_test.pl
  unsent_diagnosis_status_alert.pl
  manual_xml_transfer.pl
  genomics_xml_by_curl.pl/;

my @intervals     = qw/hourly daily weekly monthly quarterly multi/;
my $cronsdir      = catdir qw/script crons/;
my %interval_dirs = map { $_ => catdir $cronsdir, $_ } @intervals;

# search through the subdirectories of crons and test the pl files are -x
find( \&wanted, values %interval_dirs );

done_testing();

# runs file_mode_is test only if file ends in .pl and is not in the stoplist
sub wanted {
    # find changes cwd so $_ is just the current filename without path
    my $file = $_;
    /.pl\z/msx
      && not( grep { $file eq $_ } @stoplist )
      && file_mode_is( $file, 0755, "$File::Find::name is exe" );
}

