use Test::More;
use Data::Printer;
use FindBin '$Bin'; # warn $Bin;

BEGIN {
    require 't/test-lib.pl';
}

use constant TESTS => 4;

my $dbix = get_dbix();

is(-e "$Bin/../templates/resources/menu/local/$_.test", 1, "file $_ found")
    for qw( file_uploads request_forms );

my @databases = $dbix->query('SHOW DATABASES')->flat; # p \@databases;
for my $db ( qw/hmrn_test outreach_test/ ) {
    is( ( grep { $_ eq $db } @databases ), 1, "database $db found" );
}

done_testing(TESTS);
