package LIMS::DB::Patient;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup (
    table   => 'patients',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        last_name   => { type => 'varchar', length => 50 },
        first_name  => { type => 'varchar', length => 50 },
        middle_name => { type => 'varchar', length => 50 },
        dob         => { type => 'date' },
        gender      => { type => 'enum', check_in => [ 'M', 'F', 'U' ], default => 'U' },
        nhs_number  => { type => 'varchar', length => 10 },
        updated_at  => { type => 'timestamp', not_null => 1 },
        created_at  => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'nhs_number' ],

    relationships => [
        patient_case => {
            class      => 'LIMS::DB::PatientCase',
            column_map => { id => 'patient_id' },
            type       => 'one to many',
        },
        
        patient_demographic => {
            class      => 'LIMS::DB::PatientDemographic',
            column_map => { id => 'patient_id' },
            type       => 'one to one',
        },

        patient_demographic_history => {
            class      => 'LIMS::DB::PatientDemographicHistory',
            column_map => { id => 'patient_id' },
            type       => 'one to many',
        },

        patient_edit => {
            class => 'LIMS::DB::PatientEdit',
            column_map => { id => 'patient_id' },
            type      => 'one to many',
        },
        
        patient_note => {
            class => 'LIMS::DB::PatientNote',
            column_map => { id => 'patient_id' },
            type      => 'one to one',
        },
        
        patient_trial => {
            class      => 'LIMS::DB::PatientTrial',
            column_map => { id => 'patient_id' },
            type       => 'one to many',
        },
    ],
);
#=cut

# or to see what it should be:
#__PACKAGE__->meta->table('patients');
#__PACKAGE__->meta->auto_initialize;
# print __PACKAGE__->meta->perl_class_definition(indent => 2);

__PACKAGE__->meta->make_manager_class('patients');

1;

=begin # functionally identical to make_manager_class method above
package LIMS::DB::Patient::Manager;

use base qw(Rose::DB::Object::Manager);

sub object_class { 'LIMS::DB::Patient' }

__PACKAGE__->make_manager_methods('patients');

1;
=cut