package LIMS::Controller::Roles::User;

use Moose::Role;

has lab_staff => (
    is      => 'ro',
    isa 	=> 'ArrayRef[HashRef]',
    traits  => ['Array'],
    default => sub { [] },
	handles	=> {
        add_lab_staff_user => 'push',
    },
);

sub get_lab_staff_users {
    my $self = shift;

	my $users = $self->model('User')->get_all_users({sort_by => 'username'});

    my $lab_name
        = $self->cfg('settings')->{lab_name_abbreviation}; #  warn $lab_name;
    
    while ( my $user = $users->next ) {
        next unless $user->active eq 'yes'
            && $user->user_location->location_name eq $lab_name;
        
        my %user = (
            id => $user->id,
            username => $user->username,
        );
        
        $self->add_lab_staff_user(\%user);
    } # $self->debug($self->lab_staff);
    
    return $self->lab_staff;
}

#-------------------------------------------------------------------------------
sub generate_new_password {
    my $self = shift;

    srand;

    my @chars = ('a' .. 'z', 'A' .. 'Z', 0 .. 9 );

    my $new_password;

    for (1 .. 10) {
        my $rand = int(rand @chars);
        $new_password .= $chars[$rand];
    }

    return $new_password;
}

1;
