package LIMS::Controller::Admin::Config::RequestAuditOptions;

use strict;
use warnings;

use base 'LIMS::Controller::Admin';

__PACKAGE__->authz->authz_runmodes(	':all' => 'do_admin' );

# ------------------------------------------------------------------------------
sub default : StartRunmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift; # $self->stash( errs => $errs );    

    # first check we have at least 1 request category defined:
	unless ($self->have_request_audit_categories) {
        my $msg = $self->messages('admin')->{no_request_audit_categories};
        $self->stash( error_msg => $msg );
        return $self->forward('missing_data');
    }

    my %args = ( sort_by => $self->query->param('sort_by') || 'description' );

    my $total = $self->model('Base')->get_objects_count('AuditRequestOption');

    if ( $total > $self->cfg('settings')->{entries_per_page} ) {
        # invoke pager for template and add limit & offset params to \%args:
        $self->pager({ query => \%args, total => $total });
    }

	my $request_options  = $self->model('RequestAudit')->get_audit_options(\%args);
	my $request_categories
        = $self->model('RequestAudit')->get_audit_categories;

    $self->tt_params(
		request_options    => $request_options,
        request_categories => $request_categories,
	);

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('request_audit_options');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
sub edit : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);
    my $errs = shift;

    my $id = $self->param('id')
    || return $self->error('no id passed to '.$self->get_current_runmode);  # $self->debug('id:'.$id);

    my $data = $self->model('RequestAudit')->get_request_audit_option($id);

	my $categories
        = $self->model('RequestAudit')->get_audit_categories;

    $self->tt_params(
        data       => $data,
        categories => $categories,
    );

    # get js validation foo_onsubmit & foo_dfv_js vars into tt_params:
    $self->js_validation_profile('request_audit_options');

    return $self->tt_process($errs);
}

# -------------------------------------------------------------------------------------
sub update : Runmode {
    my $self = shift; $self->_debug_path($self->get_current_runmode);

    my $id = $self->param('id') || '';  # $self->debug('id:'.$id);

	# put id (if submitted) into params() as _record_id for validation:	
    if ( $id ) { 
        $self->query->param( _record_id => $id );
    }

    # if param 'id' passed, return error to edit():
    my $error_rm = $id ? 'edit' : 'default';

	my $dfv = $self->check_rm($error_rm, $self->validate('request_audit_options') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param

	# provide 'id' if supplied, so record updated, otherwise new one created: 
	if ($id) { $data->{id} = $id; }

    my $rtn = $self->model('RequestAudit')->update_request_audit_options($data); 

    return $rtn ?
        $self->error($rtn) :
            $self->redirect( $self->query->url . '/config/request-audit-options' );
}

1;