package LIMS::DB::AdditionalOption;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'additional_options',

    columns => [
        id           => { type => 'serial', not_null => 1 },
        option_name  => { type => 'varchar', length => 255 },
        option_label => { type => 'varchar', length => 255 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ],
                          default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [
        [ 'option_name' ],
        [ 'option_label' ],
    ],
    
    relationships => [
        request_option => {
            class      => 'LIMS::DB::RequestOption',
            column_map => { id => 'option_id' },
            type       => 'one to many',
        },
    ],
);

#=cut

__PACKAGE__->meta->make_manager_class('additional_options');

1;
