package LIMS::DB::Outreach::QuestionnaireSymptoms;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_symptoms',
    
    columns => [
        request_id              => { type => 'integer', not_null => 1 },
        weight                  => { type => 'float', precision => 32 },
        weight_loss             => { type => 'enum', check_in => [ 'Y', 'N' ] },
        night_sweats            => { type => 'enum', check_in => [ 'none', 'occasional', 'frequent', 'drenching' ] },
        persistent_night_sweats => { type => 'enum', check_in => [ 'Y', 'N' ] },
        serious_infection       => { type => 'enum', check_in => [ 'Y', 'N' ] },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);
#=cut

__PACKAGE__->meta->make_manager_class('questionnaire_symptoms');

1;
