#!/usr/bin/perl

use strict;
use warnings;

# if using LIMS::LogDispatch, need to load all required modules there

use LIMS::Local::Utils;
my $path_to_app_root = LIMS::Local::Utils::find_home;

{
    log_dispatch => {
        LOG_DISPATCH_MODULES => [
#----------------------------------------------------------------------
            {
                module 		=> 'Log::Dispatch::Screen',
                name 		=> 'screen',
                min_level 	=> 'debug', # level 0
                std_err     => 1,
                append_newline => 0,
            },
#----------------------------------------------------------------------
            {
                module      => 'Log::Dispatch::File',
                name        => 'debug_log',
                min_level   => 'debug', # level 0
                filename    => "$path_to_app_root/logs/debug.log",
                permissions => 0666,
                mode        => 'append',
            },
#----------------------------------------------------------------------
            {
                module      => 'Log::Dispatch::File',
                name 		=> 'debug_tmp',
                min_level   => 'debug', # level 0
                filename    => "$path_to_app_root/logs/debug.txt",
                permissions => 0666,
                mode        => 'write',
            },
#----------------------------------------------------------------------
#            {
#                module      => 'Log::Dispatch::Email::MailSendmail', # 'My::LogDispatch::Email',
#                name        => 'email',
#                from        => 'hmds.lth@nhs.net',
#                to          => [ qw(ra.jones@hmds.org.uk hmds.lth@nhs.net) ], #
#                subject     => 'LIMS Error',
#                min_level   => 'emergency', # level 7 - handled by LIMS::Local::ErrorHandler now
#                smtp        => 'smtp.talktalk.net', # 'smtp.leedsth.nhs.uk',
#            },
#----------------------------------------------------------------------
        ],
#		APPEND_NEWLINE => 1, # set global for all Log::Dispatch:: modules, or set locally using append_newline => 1,
#       LOG_METHOD_EXECUTION => [ qw( __PACKAGE__ CGI ) ], # causing Sub::WrapPackages errors
    },
}

__END__
            # FileRotate causes performance hit
            {
                module      => 'Log::Dispatch::FileRotate',
                name 		=> 'debug',
                min_level   => 'debug', # level 0
                filename    => "$path_to_app_root/logs/debug.log",
                permissions => 0666,
                mode        => 'append',
                DatePattern => 'yyyy-MM-dd', # or size => 1, # operates in date or size mode
                max         => 3,
            },
            {
                module      => 'Log::Dispatch::File::Rolling',
                name        => 'rolling',
                min_level   => 'info', # level 1
                filename    => "$path_to_app_root/logs/lims_debug_%d{yyyy_MMdd}.log",
                permissions => 0666,
                mode        => 'append',
            },
            {
                module 		=> 'Log::Dispatch::File',
                name 		=> 'debug',
                filename 	=> "$path_to_app_root/logs/debug.log",
                min_level 	=> 'info', # level 1
                mode        => 'write',
                append_newline => 0,
            },
