-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               5.5.60-0+deb7u1 - (Debian)
-- Server OS:                    debian-linux-gnu
-- HeidiSQL Version:             9.5.0.5295
-- --------------------------------------------------------
USE outreach_test;

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- Dumping structure for table outreach.defaults_and_ranges
CREATE TABLE IF NOT EXISTS `defaults_and_ranges` (
  `param_id` smallint(6) NOT NULL DEFAULT '0',
  `lower_limit` decimal(10,2) DEFAULT NULL,
  `upper_limit` decimal(10,2) DEFAULT NULL,
  `default` decimal(10,2) DEFAULT NULL,
  `lower_flag` decimal(10,2) DEFAULT NULL,
  `upper_flag` decimal(10,3) DEFAULT NULL,
  `units` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`param_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.diagnoses
CREATE TABLE IF NOT EXISTS `diagnoses` (
  `diagnosis_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`diagnosis_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `diagnoses` (`diagnosis_id`) VALUES
	(1),
	(2);

-- Data exporting was unselected.
-- Dumping structure for table outreach.followup_options
CREATE TABLE IF NOT EXISTS `followup_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `option` varchar(20) DEFAULT NULL,
  `label` varchar(25) DEFAULT NULL,
  `position` tinyint(3) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `position` (`position`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
INSERT INTO `followup_options` (`option`,`label`,`position`) VALUES
	('zero_month', 'immediately', 1),
	('one_month', 'one month', 2),
	('six_week', 'six weeks', 3),
	('twenty_four_month', 'two years', 4),
	('clinic_return', 'return to clinic', 5),
	('other', 'other', 6);

-- Data exporting was unselected.
-- Dumping structure for table outreach.lab_params
CREATE TABLE IF NOT EXISTS `lab_params` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `param_name` varchar(25) NOT NULL DEFAULT '',
  `field_label` varchar(255) NOT NULL DEFAULT '',
  `field_type` enum('menu','int','decimal') DEFAULT 'int',
  `department_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `param_name` (`param_name`),
  KEY `department_id` (`department_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.menu_options
CREATE TABLE IF NOT EXISTS `menu_options` (
  `field_name` varchar(255) NOT NULL,
  `detail` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`field_name`,`detail`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.nodal_options
CREATE TABLE IF NOT EXISTS `nodal_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `option` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.non_participant_practice
CREATE TABLE IF NOT EXISTS `non_participant_practice` (
  `practice_id` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`practice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.notification_events
CREATE TABLE IF NOT EXISTS `notification_events` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `days` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `event` (`days`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.pain_options
CREATE TABLE IF NOT EXISTS `pain_options` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `option` varchar(25) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.patient_access
CREATE TABLE IF NOT EXISTS `patient_access` (
  `patient_id` int(11) unsigned NOT NULL,
  `email` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `last_login` datetime NOT NULL DEFAULT '1900-01-01 00:00:00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.patient_alternate_address
CREATE TABLE IF NOT EXISTS `patient_alternate_address` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `address` varchar(255) NOT NULL DEFAULT '',
  `post_code` varchar(8) NOT NULL DEFAULT '',
  PRIMARY KEY (`patient_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC;

-- Data exporting was unselected.
-- Dumping structure for table outreach.patient_dispatch_detail
CREATE TABLE IF NOT EXISTS `patient_dispatch_detail` (
  `patient_id` int(11) NOT NULL DEFAULT '0',
  `dispatch_to` enum('home','alternate','GP') NOT NULL DEFAULT 'home',
  PRIMARY KEY (`patient_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.practice_blood_tube
CREATE TABLE IF NOT EXISTS `practice_blood_tube` (
  `practice_id` smallint(6) NOT NULL DEFAULT '0',
  `tube_type` enum('vacutainer','monovette') DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`practice_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

-- Data exporting was unselected.
-- Dumping structure for table outreach.questionnaire_adenopathy
CREATE TABLE IF NOT EXISTS `questionnaire_adenopathy` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `nodal_option_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`request_id`,`nodal_option_id`),
  KEY `nodal_options` (`nodal_option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.questionnaire_eq5d
CREATE TABLE IF NOT EXISTS `questionnaire_eq5d` (
  `request_id` int(11) NOT NULL,
  `mobility` enum('A','B','C') DEFAULT NULL,
  `self_care` enum('A','B','C') DEFAULT NULL,
  `usual_activity` enum('A','B','C') DEFAULT NULL,
  `discomfort` enum('A','B','C') DEFAULT NULL,
  `anxiety` enum('A','B','C') DEFAULT NULL,
  `health_index` smallint(3) DEFAULT NULL,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.questionnaire_pain
CREATE TABLE IF NOT EXISTS `questionnaire_pain` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `pain_option_id` smallint(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`request_id`,`pain_option_id`),
  KEY `pain_options` (`pain_option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.questionnaire_service
CREATE TABLE IF NOT EXISTS `questionnaire_service` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `opinion` enum('happy','unhappy') DEFAULT NULL,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.questionnaire_symptoms
CREATE TABLE IF NOT EXISTS `questionnaire_symptoms` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `weight_loss` enum('Y','N','U') DEFAULT 'U',
  `night_sweats` enum('none','occasional','frequent','drenching','unstated') DEFAULT 'unstated',
  `adenopathy` enum('none','stable','unstable','unstated') DEFAULT 'unstated',
  `pain` enum('none','stable','unstable','unstated') DEFAULT 'unstated',
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.request_clinic_return
CREATE TABLE IF NOT EXISTS `request_clinic_return` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `appointment_date` date NOT NULL,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.request_cml_prescription
CREATE TABLE IF NOT EXISTS `request_cml_prescription` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `date_requested` date NOT NULL,
  `date_generated` date DEFAULT NULL,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.request_followup
CREATE TABLE IF NOT EXISTS `request_followup` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `followup_option_id` smallint(6) NOT NULL DEFAULT '0',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`),
  KEY `followup_option_id` (`followup_option_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.request_notification
CREATE TABLE IF NOT EXISTS `request_notification` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `event_id` smallint(6) NOT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`),
  KEY `request_notification_ibfk_1` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.request_pack_dispatch
CREATE TABLE IF NOT EXISTS `request_pack_dispatch` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `pack_due` date DEFAULT NULL,
  `pack_sent` date DEFAULT NULL,
  `return_due` date DEFAULT NULL,
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.request_report_issued
CREATE TABLE IF NOT EXISTS `request_report_issued` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.request_results
CREATE TABLE IF NOT EXISTS `request_results` (
  `request_id` int(11) NOT NULL DEFAULT '0',
  `param_id` smallint(6) NOT NULL DEFAULT '0',
  `result` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`request_id`,`param_id`),
  KEY `request_results_ibfk_1` (`param_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
-- Dumping structure for table outreach.result_types
CREATE TABLE IF NOT EXISTS `result_types` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `description` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

-- Data exporting was unselected.
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IF(@OLD_FOREIGN_KEY_CHECKS IS NULL, 1, @OLD_FOREIGN_KEY_CHECKS) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
