#!/usr/bin/env perl

# checks a word file against aspell en_GB master dict + en-medical.rws extra-dict
# & .aspell.leeds.pws personal dict - dumps unrecognised words in temp file

use Modern::Perl qw(2012);
use Data::Printer;
use Data::Dumper;
use Text::Aspell;
use Path::Tiny;
use IO::All;
use FindBin;

#===============================================================================
my @files = ('.aspell.en.pws'); # files to word check
#===============================================================================

open my $fh, '>', path($FindBin::Bin, 'debug.txt');	

my $personal = path($FindBin::Bin, '.aspell.leeds.pws')->realpath;
my $tempdict = path($FindBin::Bin, '.aspell.leeds.temp')->realpath;
my $medical  = path($FindBin::Bin, 'en-medical.rws')->realpath;

my $speller = Text::Aspell->new; # p $speller;

my %opts = (
	'lang' 	   => 'en_GB',
	'sug-mode' => 'fast',	
    'personal' => $personal,
    'extra-dicts' => $medical,
	'ignore-case' => 'true',
); # p %opts; exit;

$speller->set_option( $_ => $opts{$_} ) for keys %opts;
# $speller->print_config; exit;

for (@files) {
#    next unless $_->filename =~ /.pws$/ && $_->filename !~ /^medterms/; # warn $_->filename;
    my $file = path($FindBin::Bin, $_)->realpath;
    my @contents = io($file)->chomp->slurp; # p @contents;
    my @unrecognised = grep { ! $speller->check( $_ ) } sort @contents; # p @unrecognised;
    # add to temp file for inclusion in persoanl dict:
    undef > io($tempdict); # clear 1st
    $_ . "\n" >> io($tempdict) for @unrecognised; # print $fh $_, "\n" for @unrecognised;
}