/* 
The first insert adds a "N/A" as an available option.
Then the following 3 Inserts will associate "N/A" with bone lesions and binet, and associate "Not Done" with Paraprotein.
*/

-- ADD EXTRA MENU OPTIONS
--		bone_lesions    --add "N/A" option
--		binet           --add "N/A" option
--		Paraprotein     --add "Not Done" option
-- ------------------------------------------------------------------------
-- Insert N/A as A menu_item
INSERT INTO menu_items (item_value)
VALUES ('N/A');
-- ------------------------------------------------------------------------

-- bone_lesions > Add "N/A" option
INSERT INTO parameter_menu_item(param_id, item_id)
SELECT
	(SELECT id FROM parameters WHERE param_name = 'bone_lesions'),
	(SELECT item_id FROM menu_items WHERE item_value = 'N/A')
ON DUPLICATE KEY UPDATE param_id=param_id;

--	binet > add "N/A" option
INSERT INTO parameter_menu_item(param_id, item_id)
SELECT
	(SELECT id FROM parameters WHERE param_name = 'binet'),
	(SELECT item_id FROM menu_items WHERE item_value = 'N/A')
ON DUPLICATE KEY UPDATE param_id=param_id;

--	Paraprotein > add "Not Done" option
INSERT INTO parameter_menu_item(param_id, item_id)
SELECT
	(SELECT id FROM parameters WHERE param_name = 'paraprotein'),
	(SELECT item_id FROM menu_items WHERE item_value = 'not done')
ON DUPLICATE KEY UPDATE param_id=param_id;