use Modern::Perl;

# updates request_storage.concentration value from csv file

use lib '/home/raj/apps/HILIS4/lib';

use LIMS::Local::ScriptHelpers;
use Data::Printer alias => 'ddp';
use Text::CSV;
use IO::File;

my $tools = LIMS::Local::ScriptHelpers->new();
my $dbix  = $tools->dbix();

my $src_file  = './Requantification.csv';

my $io = new IO::File;
open( $io, '<', $src_file ) || die $!;

my $opt   = { binary => 1 }; # recommended to set true
    
my $csv = Text::CSV->new($opt); # ddp $csv; exit;

my $head = $csv->getline($io);
$csv->column_names( $head );

my $i = 0;
my $tbl = 'hilis4.request_storage';

while ( my $ref = $csv->getline_hr($io) ) { # ddp $ref;
	my $old_conc = $ref->{old_concentration};
	my $new_conc = $ref->{concentration};
	my $vial_id  = $ref->{vialId};
	
	my %args = ( vialId => $vial_id, concentration => $old_conc );
	unless ( $dbix->select($tbl, 1, \%args )->list ) {
		warn "$vial_id not $old_conc"; next;
	}
	
	$dbix->update($tbl, 
		{ concentration => $new_conc }, 
		{ vialId => $vial_id }
	);
	$i++;
}	

warn "updated $i records";