package LIMS::DB::DiagnosisLabTest;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup (
    table   => 'diagnosis_lab_test',

    columns => [
        diagnosis_id  => { type => 'integer', not_null => 1 },
        lab_test_id   => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'diagnosis_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { diagnosis_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('diagnosis_lab_tests');

1;
