select lt.test_name, tr.result
from request_lab_test_results tr
	join lab_tests lt on tr.lab_test_id = lt.id
	join lab_test_data_type dt on dt.lab_test_id = lt.id
	join lab_test_result_data_types rdt on dt.data_type_id = rdt.id	
where rdt.description = 'decimal'
order by lt.id;

select lt.test_name, tr.result
from request_lab_test_results tr
	join lab_tests lt on tr.lab_test_id = lt.id
where tr.result regexp '[0-9]{7}[[.full-stop.]][0-9]'
order by lt.id;

select lt.field_label, rdt.description
from lab_test_data_type dt
	join lab_tests lt on dt.lab_test_id = lt.id
	join lab_test_result_data_types rdt on dt.data_type_id = rdt.id
where lt.test_name in (
	'tumour_size',
	'volume_stored',
	'tumour_fluidx_vol',
	'family_id',
	'edta1_fluidx_vol',
	'bm_dna_fluidx_vol',
	'bm_dna_volume_stored',
	'saliva_dna_fluidx_vol',
	'saliva_dna_volume_stored',
	'tumour_volume_stored',
	'bm_tumour_size',
	'tumour_size',
	
	'tumour_sample_id',
	'oragene_tube_1',
	'bm_sample_id',
	'paxgene_rna',
	'edta1',
	'edta2',
	'pst',
	'sst'
)
order by lt.field_label;