use Modern::Perl;

# updates storage_racks.location value from csv file

use lib '/home/raj/perl-lib';

use Data::Printer alias => 'ddp';
use Local::DB;
use Text::CSV;
use IO::File;

my $dbix = Local::DB->dbix({ dbname => 'hilis4' });

my $src_file  = './storage_rack_locations.csv';

my $io = new IO::File;
open( $io, '<', $src_file ) || die $!;

my $opt = { binary => 1 }; # recommended to set true
    
my $csv = Text::CSV->new($opt); # ddp $csv; exit;

my $head = $csv->getline($io);
$csv->column_names( $head ); 

my $i = 0;
my $tbl = 'hilis4.storage_racks';

while ( my $ref = $csv->getline_hr($io) ) { # ddp $ref;
    my $plateId = $ref->{'Plate ID'} or next;
    
	unless ( $dbix->count($tbl, { plateId => $plateId }) ) {
		warn "$plateId not present"; next;
	} warn "$plateId IS present"; next;
    my $rack = $ref->{Rack}; # warn $rack;
    my $tray = $ref->{Tray}; # warn $tray;
    my $type = $ref->{Type}; # warn $type;
	
    $rack =~ s/14MG - //;
    $type =~ s/Real\-time/RealTime/;
    
    my $location = join '/', $type, $rack, $tray; # ddp $location;
    
	$dbix->update($tbl, 
		{ storage_location => $location }, 
		{ plateId => $plateId }
	);
	$i++;
}	

warn "updated $i records";