package LIMS::DB::StatusOption;

use base qw(LIMS::RDBO);

#=begin
__PACKAGE__->meta->setup(
    table   => 'status_options',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        description => { type => 'varchar', length => 255 , not_null => 1 },
        is_editable => { type => 'enum', check_in => [ 'yes', 'no' ],
                          default => 'yes', not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ],
                          default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
    
    relationships => [
        requests => {
            class      => 'LIMS::DB::Request',
            column_map => { id => 'status_option_id' },
            type       => 'one to many',
        },
    ],
);

#=cut

__PACKAGE__->meta->make_manager_class('status_options');

1;
