# generated automatically by script/make_classes.pl

#---------------------------------------------------------------------------
package LIMS::AdditionalOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'additional_options',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        option_name  => { type => 'varchar', length => 255 },
        option_label => { type => 'varchar', length => 255 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'option_label' ],
        [ 'option_name' ],
    ],

    relationships => [
        request_option => {
            class      => 'LIMS::RequestOption',
            column_map => { id => 'option_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::AdminMessage;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'admin_messages',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        message     => { type => 'text', length => 65535, not_null => 1 },
        valid_until => { type => 'date' },
        user_group  => { type => 'enum', check_in => [ 'internal', 'external', 'all' ], default => 'all', not_null => 1 },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::AuditRequestCategory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'audit_request_categories',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        audit_request_options => {
            class      => 'LIMS::AuditRequestOption',
            column_map => { id => 'category_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::AuditRequestOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'audit_request_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        category_id => { type => 'integer', default => '0', not_null => 1 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    foreign_keys => [
        category => {
            class       => 'LIMS::AuditRequestCategory',
            key_columns => { category_id => 'id' },
        },
    ],

    relationships => [
        request_audit => {
            class      => 'LIMS::RequestAudit',
            column_map => { id => 'audit_request_option_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ClinicalTrial;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'clinical_trials',

    columns => [
        id         => { type => 'integer', not_null => 1 },
        trial_name => { type => 'varchar', length => 50 },
        active     => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'trial_name' ],

    relationships => [
        patient_trial => {
            class      => 'LIMS::PatientTrial',
            column_map => { id => 'trial_id' },
            type       => 'one to many',
        },

        request_trial => {
            class      => 'LIMS::RequestTrial',
            column_map => { id => 'trial_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ConsentOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'consent_options',

    columns => [
        id            => { type => 'integer', not_null => 1 },
        consent_name  => { type => 'varchar', default => '', length => 255, not_null => 1 },
        consent_label => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active     => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'consent_label' ],
        [ 'consent_name' ],
    ],

    relationships => [
        request_consent => {
            class      => 'LIMS::RequestConsent',
            column_map => { id => 'consent_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ContextWarningDiagnosi;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'context_warning_diagnosis',

    columns => [
        id                 => { type => 'integer', not_null => 1 },
        diagnosis_id       => { type => 'integer', default => '0', not_null => 1 },
        context_warning_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'diagnosis_id' ],

    foreign_keys => [
        context_warning => {
            class       => 'LIMS::DiagnosisContextWarning',
            key_columns => { context_warning_id => 'id' },
        },

        diagnosis => {
            class       => 'LIMS::Diagnos',
            key_columns => { diagnosis_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::DeletedRequest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'deleted_requests',

    columns => [
        id             => { type => 'serial', not_null => 1 },
        request_id     => { type => 'integer', default => '0', not_null => 1 },
        request_number => { type => 'integer', default => '0', not_null => 1 },
        year           => { type => 'scalar', default => '0000', length => 4, not_null => 1 },
        action         => { type => 'varchar', default => '', length => 255, not_null => 1 },
        user_id        => { type => 'integer', default => '0', not_null => 1 },
        time           => { type => 'datetime' },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Diagnos;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnoses',

    columns => [
        id                     => { type => 'integer', not_null => 1 },
        name                   => { type => 'varchar', length => 255 },
        icdo3                  => { type => 'varchar', length => 6 },
        diagnostic_category_id => { type => 'integer' },
        active                 => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'name' ],

    foreign_keys => [
        diagnostic_category => {
            class       => 'LIMS::DiagnosticCategory',
            key_columns => { diagnostic_category_id => 'id' },
        },
    ],

    relationships => [
        auth_diagnosis_objs => {
            map_class => 'LIMS::RequestAuthorisationDiagnosi',
            map_from  => 'report_diagnosis',
            map_to    => 'auth_diagnosis',
            type      => 'many to many',
        },

        context_warnings => {
            map_class => 'LIMS::ContextWarningDiagnosi',
            map_from  => 'diagnosis',
            map_to    => 'context_warning',
            type      => 'many to many',
        },

        report_diagnosis_objs => {
            map_class => 'LIMS::RequestAuthorisationDiagnosi',
            map_from  => 'auth_diagnosis',
            map_to    => 'report_diagnosis',
            type      => 'many to many',
        },

        request_authorisation_diagnosis => {
            class      => 'LIMS::RequestAuthorisationDiagnosi',
            column_map => { id => 'auth_diagnosis_id' },
            type       => 'one to many',
        },

        request_authorisation_diagnosis_objs => {
            class      => 'LIMS::RequestAuthorisationDiagnosi',
            column_map => { id => 'report_diagnosis_id' },
            type       => 'one to many',
        },

        request_diagnosis_history => {
            class      => 'LIMS::RequestDiagnosisHistory',
            column_map => { id => 'diagnosis_id' },
            type       => 'one to many',
        },

        request_report => {
            class      => 'LIMS::RequestReport',
            column_map => { id => 'diagnosis_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::DiagnosisChangeOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnosis_change_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        option_name => { type => 'varchar', length => 25, not_null => 1 },
        description => { type => 'varchar', length => 255, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'option_name' ],

    relationships => [
        request_diagnosis_history => {
            class      => 'LIMS::RequestDiagnosisHistory',
            column_map => { id => 'option_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::DiagnosisContextWarning;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnosis_context_warnings',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        diagnosis_objs => {
            map_class => 'LIMS::ContextWarningDiagnosi',
            map_from  => 'context_warning',
            map_to    => 'diagnosis',
            type      => 'many to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::DiagnosticCategory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'diagnostic_categories',

    columns => [
        id            => { type => 'integer', not_null => 1 },
        description   => { type => 'varchar', length => 255 },
        category_type => { type => 'enum', check_in => [ 'main', 'sub' ] },
        active        => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        diagnoses => {
            class      => 'LIMS::Diagnos',
            column_map => { id => 'diagnostic_category_id' },
            type       => 'one to many',
        },

        icdo_category => {
            class      => 'LIMS::IcdoCategory',
            column_map => { id => 'diagnostic_category_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::EmailAddress;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'email_addresses',

    columns => [
        address => { type => 'varchar', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'address' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::EmailContact;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'email_contacts',

    columns => [
        id                 => { type => 'integer', not_null => 1 },
        display_name       => { type => 'varchar', default => '', length => 255, not_null => 1 },
        scope              => { type => 'enum', check_in => [ 'hospital', 'organisation', 'department' ] },
        referral_source_id => { type => 'integer', default => '0', not_null => 1 },
        type               => { type => 'enum', check_in => [ 'mdt', 'report' ] },
        contact_address    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active          => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'referral_source_id', 'type', 'contact_address' ],

    foreign_keys => [
        referral_source => {
            class       => 'LIMS::ReferralSource',
            key_columns => { referral_source_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ErrorCode;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'error_codes',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        code        => { type => 'varchar', length => 2 },
        description => { type => 'varchar', length => 255 },
        is_unique   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'code' ],

    relationships => [
        patient_edits => {
            class      => 'LIMS::PatientEdit',
            column_map => { id => 'error_code_id' },
            type       => 'one to many',
        },

        report_error_code => {
            class                => 'LIMS::ReportErrorCode',
            column_map           => { code => 'code' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_error_code => {
            class      => 'LIMS::RequestErrorCode',
            column_map => { id => 'error_code_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::HospitalDepartment;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'hospital_departments',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        display_name => { type => 'varchar', default => '', length => 50, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'display_name' ],

    relationships => [
        referrer_department => {
            class      => 'LIMS::ReferrerDepartment',
            column_map => { id => 'hospital_department_code' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::IcdoCategory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'icdo_category',

    columns => [
        diagnostic_category_id => { type => 'integer', not_null => 1 },
        icdo3                  => { type => 'varchar', length => 6, not_null => 1 },
    ],

    primary_key_columns => [ 'diagnostic_category_id', 'icdo3' ],

    foreign_keys => [
        diagnostic_category => {
            class       => 'LIMS::DiagnosticCategory',
            key_columns => { diagnostic_category_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabSection;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_sections',

    columns => [
        id                 => { type => 'integer', not_null => 1 },
        section_name       => { type => 'varchar', length => 255, not_null => 1 },
        has_result_summary => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        has_section_notes  => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        has_test_sign_out  => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        has_foreign_id     => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        has_results_import => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        is_active          => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'section_name' ],

    relationships => [
        lab_section_sample_type => {
            class      => 'LIMS::LabSectionSampleType',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },

        lab_section_status_option => {
            class      => 'LIMS::LabSectionStatusOption',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },

        lab_tests => {
            class      => 'LIMS::LabTest',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },

        request_lab_section_foreign_id => {
            class      => 'LIMS::RequestLabSectionForeignId',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },

        requests => {
            map_class => 'LIMS::RequestLabSectionNote',
            map_from  => 'lab_section',
            map_to    => 'request',
            type      => 'many to many',
        },

        result_summary_options => {
            class      => 'LIMS::ResultSummaryOption',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },

        screen_lab_test_detail => {
            class      => 'LIMS::ScreenLabTestDetail',
            column_map => { id => 'lab_section_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabSectionSampleType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_section_sample_type',

    columns => [
        lab_section_id => { type => 'integer', not_null => 1 },
        sample_type_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'sample_type_id', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        sample_type => {
            class       => 'LIMS::SampleType',
            key_columns => { sample_type_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabSectionStatusOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_section_status_option',

    columns => [
        lab_section_id   => { type => 'integer', not_null => 1 },
        status_option_id => { type => 'integer', not_null => 1 },
        position         => { type => 'integer' },
    ],

    primary_key_columns => [ 'lab_section_id', 'status_option_id' ],

    unique_key => [ 'position', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        status_option => {
            class       => 'LIMS::LabTestStatusOption',
            key_columns => { status_option_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_tests',

    columns => [
        id             => { type => 'integer', not_null => 1 },
        test_name      => { type => 'varchar', length => 25, not_null => 1 },
        field_label    => { type => 'varchar', length => 25, not_null => 1 },
        lab_section_id => { type => 'integer', default => '0', not_null => 1 },
        test_type      => { type => 'enum', check_in => [ 'test', 'panel' ] },
        has_results    => { type => 'enum', check_in => [ 'yes', 'no' ] },
        is_active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'lab_section_id', 'test_type', 'field_label' ],
        [ 'lab_section_id', 'test_type', 'test_name' ],
    ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::LabSection',
            key_columns => { lab_section_id => 'id' },
        },
    ],

    relationships => [
        lab_test_data_type => {
            class                => 'LIMS::LabTestDataType',
            column_map           => { id => 'lab_test_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        panel_lab_test => {
            class      => 'LIMS::PanelLabTest',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        panel_lab_test_objs => {
            class      => 'LIMS::PanelLabTest',
            column_map => { id => 'panel_test_id' },
            type       => 'one to many',
        },

        pre_registration_lab_test => {
            class      => 'LIMS::PreRegistrationLabTest',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        request_lab_test_status => {
            class      => 'LIMS::RequestLabTestStatu',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        requests => {
            map_class => 'LIMS::RequestLabTestResult',
            map_from  => 'lab_test',
            map_to    => 'request',
            type      => 'many to many',
        },

        screen_lab_test => {
            class      => 'LIMS::ScreenLabTest',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        specimen_lab_test => {
            class      => 'LIMS::SpecimenLabTest',
            column_map => { id => 'lab_test_id' },
            type       => 'one to many',
        },

        status_options => {
            map_class => 'LIMS::RequestLabTestStatu',
            map_from  => 'lab_test',
            map_to    => 'status_option',
            type      => 'many to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestDataType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_test_data_type',

    columns => [
        lab_test_id  => { type => 'integer', not_null => 1 },
        data_type_id => { type => 'integer', default => '0', not_null => 1 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'lab_test_id' ],

    foreign_keys => [
        data_type => {
            class       => 'LIMS::LabTestResultDataType',
            key_columns => { data_type_id => 'id' },
        },

        lab_test => {
            class       => 'LIMS::LabTest',
            key_columns => { lab_test_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestResultDataType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_test_result_data_types',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 25, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        lab_test_data_type => {
            class      => 'LIMS::LabTestDataType',
            column_map => { id => 'data_type_id' },
            type       => 'one to many',
        },

        lab_test_result_options => {
            class      => 'LIMS::LabTestResultOption',
            column_map => { id => 'data_type_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestResultOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_test_result_options',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        data_type_id => { type => 'integer', default => '0', not_null => 1 },
        value        => { type => 'varchar', default => '', length => 30, not_null => 1 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'data_type_id', 'value' ],

    foreign_keys => [
        data_type => {
            class       => 'LIMS::LabTestResultDataType',
            key_columns => { data_type_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LabTestStatusOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'lab_test_status_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_editable => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        lab_section_status_option => {
            class      => 'LIMS::LabSectionStatusOption',
            column_map => { id => 'status_option_id' },
            type       => 'one to many',
        },

        lab_tests => {
            map_class => 'LIMS::RequestLabTestStatu',
            map_from  => 'status_option',
            map_to    => 'lab_test',
            type      => 'many to many',
        },

        request_lab_test_status => {
            class      => 'LIMS::RequestLabTestStatu',
            column_map => { id => 'status_option_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::LocalNetworkLocation;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'local_network_locations',

    columns => [
        parent_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'parent_id' ],

    foreign_keys => [
        parent => {
            class       => 'LIMS::ParentOrganisation',
            key_columns => { parent_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Location;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'locations',

    columns => [
        id       => { type => 'serial', not_null => 1 },
        location => { type => 'varchar', default => '', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Login;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'logins',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        address    => { type => 'varchar', length => 15 },
        browser    => { type => 'varchar', length => 255 },
        session_id => { type => 'character', length => 32 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PanelLabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'panel_lab_test',

    columns => [
        panel_test_id => { type => 'integer', not_null => 1 },
        lab_test_id   => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'panel_test_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        panel_test => {
            class       => 'LIMS::LabTest',
            key_columns => { panel_test_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ParentOrganisation;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'parent_organisations',

    columns => [
        id               => { type => 'integer', not_null => 1 },
        parent_code      => { type => 'varchar', default => '', length => 6, not_null => 1 },
        description      => { type => 'varchar', default => '', length => 255, not_null => 1 },
        referral_type_id => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'description' ],
        [ 'parent_code' ],
    ],

    foreign_keys => [
        referral_type => {
            class       => 'LIMS::ReferralType',
            key_columns => { referral_type_id => 'id' },
        },
    ],

    relationships => [
        local_network_location => {
            class                => 'LIMS::LocalNetworkLocation',
            column_map           => { id => 'parent_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        referral_types => {
            map_class => 'LIMS::ReferralSource',
            map_from  => 'parent_organisation',
            map_to    => 'referral_type',
            type      => 'many to many',
        },

        referrer_department => {
            class      => 'LIMS::ReferrerDepartment',
            column_map => { id => 'parent_organisation_id' },
            type       => 'one to many',
        },

        user_locations => {
            class      => 'LIMS::UserLocation',
            column_map => { parent_code => 'region_code' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Patient;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patients',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        last_name   => { type => 'varchar', length => 50 },
        first_name  => { type => 'varchar', length => 50 },
        middle_name => { type => 'varchar', length => 50 },
        dob         => { type => 'date' },
        gender      => { type => 'enum', check_in => [ 'M', 'F', 'U' ], default => 'U' },
        nhs_number  => { type => 'varchar', length => 10 },
        created_at  => { type => 'timestamp', not_null => 1 },
        updated_at  => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'nhs_number' ],

    relationships => [
        patient_case => {
            class      => 'LIMS::PatientCase',
            column_map => { id => 'patient_id' },
            type       => 'one to many',
        },

        patient_demographic => {
            class                => 'LIMS::PatientDemographic',
            column_map           => { id => 'patient_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        patient_demographic_history => {
            class      => 'LIMS::PatientDemographicHistory',
            column_map => { id => 'patient_id' },
            type       => 'one to many',
        },

        patient_edits => {
            class      => 'LIMS::PatientEdit',
            column_map => { id => 'patient_id' },
            type       => 'one to many',
        },

        patient_note => {
            class                => 'LIMS::PatientNote',
            column_map           => { id => 'patient_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        patient_trial => {
            class      => 'LIMS::PatientTrial',
            column_map => { id => 'patient_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientCase;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_case',

    columns => [
        id                 => { type => 'serial', not_null => 1 },
        patient_id         => { type => 'integer', default => '0', not_null => 1 },
        referral_source_id => { type => 'integer', default => '0', not_null => 1 },
        unit_number        => { type => 'varchar', default => 'UNKNOWN', length => 255, not_null => 1 },
        time               => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'patient_id', 'unit_number', 'referral_source_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::Patient',
            key_columns => { patient_id => 'id' },
        },

        referral_source => {
            class       => 'LIMS::ReferralSource',
            key_columns => { referral_source_id => 'id' },
        },
    ],

    relationships => [
        requests => {
            class      => 'LIMS::Request',
            column_map => { id => 'patient_case_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientDemographic;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_demographics',

    columns => [
        patient_id     => { type => 'integer', not_null => 1 },
        address        => { type => 'varchar', length => 255 },
        post_code      => { type => 'varchar', length => 8 },
        contact_number => { type => 'varchar', length => 15 },
        gp_id          => { type => 'integer', default => '0', not_null => 1 },
        practice_id    => { type => 'integer', default => '0', not_null => 1 },
        status         => { type => 'enum', check_in => [ 'alive', 'dead' ], default => 'alive', not_null => 1 },
        dod            => { type => 'date' },
        time           => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],

    foreign_keys => [
        gp => {
            class       => 'LIMS::Referrer',
            key_columns => { gp_id => 'id' },
        },

        patient => {
            class       => 'LIMS::Patient',
            key_columns => { patient_id => 'id' },
            rel_type    => 'one to one',
        },

        practice => {
            class       => 'LIMS::ReferralSource',
            key_columns => { practice_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientDemographicHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_demographic_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        patient_id => { type => 'integer', default => '0', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        action     => { type => 'varchar', default => '', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::Patient',
            key_columns => { patient_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientEdit;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_edits',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        patient_id    => { type => 'integer', default => '0', not_null => 1 },
        last_name     => { type => 'varchar', length => 50 },
        first_name    => { type => 'varchar', length => 50 },
        middle_name   => { type => 'varchar', length => 50 },
        dob           => { type => 'date' },
        gender        => { type => 'enum', check_in => [ 'M', 'F', 'U' ], default => 'U' },
        nhs_number    => { type => 'varchar', length => 10 },
        user_id       => { type => 'integer', not_null => 1 },
        error_code_id => { type => 'integer', not_null => 1 },
        time          => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        error_code => {
            class       => 'LIMS::ErrorCode',
            key_columns => { error_code_id => 'id' },
        },

        patient => {
            class       => 'LIMS::Patient',
            key_columns => { patient_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientMdtDate;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_mdt_dates',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        patient_id => { type => 'integer', default => '0', not_null => 1 },
        date       => { type => 'date' },
        timestamp  => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientNote;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_notes',

    columns => [
        patient_id => { type => 'integer', not_null => 1 },
        detail     => { type => 'text', length => 65535, not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::Patient',
            key_columns => { patient_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PatientTrial;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'patient_trial',

    columns => [
        patient_id   => { type => 'integer', not_null => 1 },
        trial_id     => { type => 'integer', not_null => 1 },
        trial_number => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'patient_id', 'trial_id' ],

    foreign_keys => [
        patient => {
            class       => 'LIMS::Patient',
            key_columns => { patient_id => 'id' },
        },

        trial => {
            class       => 'LIMS::ClinicalTrial',
            key_columns => { trial_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PhoneLogOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'phone_log_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PreRegistration;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'pre_registration',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        labno       => { type => 'varchar', default => '', length => 8, not_null => 1 },
        surname     => { type => 'varchar', length => 25 },
        is_screened => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'labno' ],

    relationships => [
        pre_registration_specimen => {
            class      => 'LIMS::PreRegistrationSpecimen',
            column_map => { id => 'pre_reg_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PreRegistrationLabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'pre_registration_lab_test',

    columns => [
        id              => { type => 'serial', not_null => 1 },
        reg_specimen_id => { type => 'integer', default => '0', not_null => 1 },
        lab_test_id     => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'reg_specimen_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        reg_specimen => {
            class       => 'LIMS::PreRegistrationSpecimen',
            key_columns => { reg_specimen_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::PreRegistrationSpecimen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'pre_registration_specimen',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        pre_reg_id    => { type => 'integer', default => '0', not_null => 1 },
        specimen_code => { type => 'character', default => '0', length => 2, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'pre_reg_id', 'specimen_code' ],

    foreign_keys => [
        pre_reg => {
            class       => 'LIMS::PreRegistration',
            key_columns => { pre_reg_id => 'id' },
        },
    ],

    relationships => [
        pre_registration_lab_test => {
            class      => 'LIMS::PreRegistrationLabTest',
            column_map => { id => 'reg_specimen_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ReferralSource;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'referral_sources',

    columns => [
        id                     => { type => 'integer', not_null => 1 },
        display_name           => { type => 'varchar', default => '', length => 255, not_null => 1 },
        organisation_code      => { type => 'varchar', default => '', length => 6, not_null => 1 },
        parent_organisation_id => { type => 'integer', default => '0', not_null => 1 },
        referral_type_id       => { type => 'integer', default => '0', not_null => 1 },
        is_active              => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'display_name' ],
        [ 'organisation_code' ],
    ],

    foreign_keys => [
        parent_organisation => {
            class       => 'LIMS::ParentOrganisation',
            key_columns => { parent_organisation_id => 'id' },
        },

        referral_type => {
            class       => 'LIMS::ReferralType',
            key_columns => { referral_type_id => 'id' },
        },
    ],

    relationships => [
        email_contacts => {
            class      => 'LIMS::EmailContact',
            column_map => { id => 'referral_source_id' },
            type       => 'one to many',
        },

        patient_case => {
            class      => 'LIMS::PatientCase',
            column_map => { id => 'referral_source_id' },
            type       => 'one to many',
        },

        patient_demographics => {
            class      => 'LIMS::PatientDemographic',
            column_map => { id => 'practice_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ReferralType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'referral_types',

    columns => [
        id              => { type => 'integer', not_null => 1 },
        description     => { type => 'varchar', default => '', length => 255, not_null => 1 },
        prefix          => { type => 'varchar', length => 2 },
        default_unknown => { type => 'varchar', default => '', length => 8, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        parent_organisations => {
            map_class => 'LIMS::ReferralSource',
            map_from  => 'referral_type',
            map_to    => 'parent_organisation',
            type      => 'many to many',
        },

        parent_organisations_objs => {
            class      => 'LIMS::ParentOrganisation',
            column_map => { id => 'referral_type_id' },
            type       => 'one to many',
        },

        referrers => {
            class      => 'LIMS::Referrer',
            column_map => { id => 'referral_type_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Referrer;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'referrers',

    columns => [
        id               => { type => 'serial', not_null => 1 },
        name             => { type => 'varchar', default => '', length => 255, not_null => 1 },
        national_code    => { type => 'varchar', default => '', length => 8, not_null => 1 },
        referral_type_id => { type => 'integer', default => '0', not_null => 1 },
        active           => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'national_code' ],

    foreign_keys => [
        referral_type => {
            class       => 'LIMS::ReferralType',
            key_columns => { referral_type_id => 'id' },
        },
    ],

    relationships => [
        patient_demographics => {
            class      => 'LIMS::PatientDemographic',
            column_map => { id => 'gp_id' },
            type       => 'one to many',
        },

        referrer_department => {
            class      => 'LIMS::ReferrerDepartment',
            column_map => { id => 'referrer_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ReferrerDepartment;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'referrer_department',

    columns => [
        id                       => { type => 'serial', not_null => 1 },
        referrer_id              => { type => 'integer', default => '0', not_null => 1 },
        parent_organisation_id   => { type => 'integer', default => '0', not_null => 1 },
        hospital_department_code => { type => 'integer', default => '0', not_null => 1 },
        is_active                => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'referrer_id', 'parent_organisation_id' ],

    foreign_keys => [
        hospital_department => {
            class       => 'LIMS::HospitalDepartment',
            key_columns => { hospital_department_code => 'id' },
        },

        parent_organisation => {
            class       => 'LIMS::ParentOrganisation',
            key_columns => { parent_organisation_id => 'id' },
        },

        referrer => {
            class       => 'LIMS::Referrer',
            key_columns => { referrer_id => 'id' },
        },
    ],

    relationships => [
        requests => {
            class      => 'LIMS::Request',
            column_map => { id => 'referrer_department_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ReportErrorCode;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'report_error_codes',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        code        => { type => 'varchar', length => 2 },
        description => { type => 'varchar', length => 255 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'code' ],

    foreign_keys => [
        error_code => {
            class       => 'LIMS::ErrorCode',
            key_columns => { code => 'code' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Request;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'requests',

    columns => [
        id                     => { type => 'serial', not_null => 1 },
        request_number         => { type => 'integer', default => '0', not_null => 1 },
        year                   => { type => 'scalar', default => '0000', length => 4, not_null => 1 },
        patient_case_id        => { type => 'integer', default => '0', not_null => 1 },
        referrer_department_id => { type => 'integer', default => '0', not_null => 1 },
        status_option_id       => { type => 'integer', default => 1, not_null => 1 },
        created_at             => { type => 'timestamp', not_null => 1 },
        updated_at             => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'request_number', 'year' ],

    foreign_keys => [
        patient_case => {
            class       => 'LIMS::PatientCase',
            key_columns => { patient_case_id => 'id' },
        },

        referrer_department => {
            class       => 'LIMS::ReferrerDepartment',
            key_columns => { referrer_department_id => 'id' },
        },

        status_option => {
            class       => 'LIMS::StatusOption',
            key_columns => { status_option_id => 'id' },
        },
    ],

    relationships => [
        lab_sections => {
            map_class => 'LIMS::RequestLabSectionNote',
            map_from  => 'request',
            map_to    => 'lab_section',
            type      => 'many to many',
        },

        lab_tests => {
            map_class => 'LIMS::RequestLabTestResult',
            map_from  => 'request',
            map_to    => 'lab_test',
            type      => 'many to many',
        },

        request_audit => {
            class      => 'LIMS::RequestAudit',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_authorisation_diagnosi => {
            class                => 'LIMS::RequestAuthorisationDiagnosi',
            column_map           => { id => 'request_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_consent => {
            class      => 'LIMS::RequestConsent',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_diagnosis_history => {
            class      => 'LIMS::RequestDiagnosisHistory',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_dispatch_log => {
            class      => 'LIMS::RequestDispatchLog',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_error_code => {
            class      => 'LIMS::RequestErrorCode',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_external_ref => {
            class                => 'LIMS::RequestExternalRef',
            column_map           => { id => 'request_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_general_note => {
            class                => 'LIMS::RequestGeneralNote',
            column_map           => { id => 'request_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_gross_description => {
            class                => 'LIMS::RequestGrossDescription',
            column_map           => { id => 'request_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_history => {
            class      => 'LIMS::RequestHistory',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_initial_screen => {
            class                => 'LIMS::RequestInitialScreen',
            column_map           => { id => 'request_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_lab_section_foreign_id => {
            class      => 'LIMS::RequestLabSectionForeignId',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_lab_test_history => {
            class      => 'LIMS::RequestLabTestHistory',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_lab_test_status => {
            class      => 'LIMS::RequestLabTestStatu',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_option => {
            class      => 'LIMS::RequestOption',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_phone_log => {
            class      => 'LIMS::RequestPhoneLog',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_print_log => {
            class      => 'LIMS::RequestPrintLog',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_report => {
            class                => 'LIMS::RequestReport',
            column_map           => { id => 'request_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_report_history => {
            class      => 'LIMS::RequestReportHistory',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_specimen => {
            class      => 'LIMS::RequestSpecimen',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },

        request_trial => {
            class                => 'LIMS::RequestTrial',
            column_map           => { id => 'request_id' },
            type                 => 'one to one',
            with_column_triggers => '0',
        },

        request_view_log => {
            class      => 'LIMS::RequestViewLog',
            column_map => { id => 'request_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestAudit;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_audit',

    columns => [
        request_id              => { type => 'integer', not_null => 1 },
        audit_request_option_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'audit_request_option_id' ],

    foreign_keys => [
        audit_request_option => {
            class       => 'LIMS::AuditRequestOption',
            key_columns => { audit_request_option_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestAuthorisationDiagnosi;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_authorisation_diagnosis',

    columns => [
        request_id          => { type => 'integer', not_null => 1 },
        report_diagnosis_id => { type => 'integer', default => '0', not_null => 1 },
        auth_diagnosis_id   => { type => 'integer', default => '0', not_null => 1 },
        user_id             => { type => 'integer', default => '0', not_null => 1 },
        time                => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        auth_diagnosis => {
            class       => 'LIMS::Diagnos',
            key_columns => { auth_diagnosis_id => 'id' },
        },

        report_diagnosis => {
            class       => 'LIMS::Diagnos',
            key_columns => { report_diagnosis_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestConsent;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_consent',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        consent_id => { type => 'integer', not_null => 1 },
        status     => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'no', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'consent_id' ],

    foreign_keys => [
        consent => {
            class       => 'LIMS::ConsentOption',
            key_columns => { consent_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestDiagnosisHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_diagnosis_history',

    columns => [
        id           => { type => 'serial', not_null => 1 },
        request_id   => { type => 'integer', not_null => 1 },
        diagnosis_id => { type => 'integer', not_null => 1 },
        option_id    => { type => 'integer', not_null => 1 },
        user_id      => { type => 'integer', not_null => 1 },
        time         => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        diagnosis => {
            class       => 'LIMS::Diagnos',
            key_columns => { diagnosis_id => 'id' },
        },

        option => {
            class       => 'LIMS::DiagnosisChangeOption',
            key_columns => { option_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestDispatchLog;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_dispatch_log',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        recipient  => { type => 'varchar', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestErrorCode;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_error_code',

    columns => [
        id            => { type => 'serial', not_null => 1 },
        request_id    => { type => 'integer', default => '0', not_null => 1 },
        error_code_id => { type => 'integer', default => '0', not_null => 1 },
        user_id       => { type => 'integer', default => '0', not_null => 1 },
        time          => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        error_code => {
            class       => 'LIMS::ErrorCode',
            key_columns => { error_code_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestExternalRef;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_external_ref',

    columns => [
        request_id         => { type => 'integer', not_null => 1 },
        external_reference => { type => 'varchar', default => '', length => 255, not_null => 1 },
        status             => { type => 'varchar', length => 255 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestGeneralNote;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_general_notes',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        detail     => { type => 'text', length => 65535 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestGrossDescription;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_gross_description',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        detail     => { type => 'text', length => 65535 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestHaematology;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_haematology',

    columns => [
        lab_number      => { type => 'character', length => 8, not_null => 1 },
        status          => { type => 'enum', check_in => [ 'verified', 'default' ], default => 'default', not_null => 1 },
        pda             => { type => 'varchar', length => 6, not_null => 1 },
        wbc             => { type => 'character', length => 4, not_null => 1 },
        wbc_f           => { type => 'integer', not_null => 1 },
        rbc             => { type => 'character', length => 4, not_null => 1 },
        rbc_f           => { type => 'integer', not_null => 1 },
        hb              => { type => 'character', length => 4, not_null => 1 },
        hb_f            => { type => 'integer', not_null => 1 },
        hct             => { type => 'character', length => 4, not_null => 1 },
        hct_f           => { type => 'integer', not_null => 1 },
        mcv             => { type => 'character', length => 4, not_null => 1 },
        mcv_f           => { type => 'integer', not_null => 1 },
        mch             => { type => 'character', length => 4, not_null => 1 },
        mch_f           => { type => 'integer', not_null => 1 },
        mchc            => { type => 'character', length => 4, not_null => 1 },
        mchc_f          => { type => 'integer', not_null => 1 },
        plt             => { type => 'character', length => 4, not_null => 1 },
        plt_f           => { type => 'integer', not_null => 1 },
        lymph_percent   => { type => 'character', length => 4, not_null => 1 },
        lymph_percent_f => { type => 'integer', not_null => 1 },
        mixed_percent   => { type => 'character', length => 4, not_null => 1 },
        mixed_percent_f => { type => 'integer', not_null => 1 },
        neutr_percent   => { type => 'character', length => 4, not_null => 1 },
        neutr_percent_f => { type => 'integer', not_null => 1 },
        lymph           => { type => 'character', length => 4, not_null => 1 },
        lymph_f         => { type => 'integer', not_null => 1 },
        mixed           => { type => 'character', length => 4, not_null => 1 },
        mixed_f         => { type => 'integer', not_null => 1 },
        neutr           => { type => 'character', length => 4, not_null => 1 },
        neutr_f         => { type => 'integer', not_null => 1 },
        created_at      => { type => 'timestamp', not_null => 1 },
        updated         => { type => 'datetime', default => '0000-00-00 00:00:00', not_null => 1 },
    ],

    primary_key_columns => [ 'lab_number' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        action     => { type => 'varchar', default => '', length => 255, not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestInitialScreen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_initial_screen',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        screen_id  => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },

        screen => {
            class       => 'LIMS::Screen',
            key_columns => { screen_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabSectionForeignId;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_section_foreign_id',

    columns => [
        request_id     => { type => 'integer', not_null => 1 },
        lab_section_id => { type => 'integer', not_null => 1 },
        foreign_id     => { type => 'varchar', default => '', length => 25, not_null => 1 },
        time           => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabSectionNote;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_section_notes',

    columns => [
        request_id     => { type => 'integer', not_null => 1 },
        lab_section_id => { type => 'integer', not_null => 1 },
        details        => { type => 'text', length => 65535 },
        time           => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabTestHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_test_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        action     => { type => 'varchar', default => '', length => 255, not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabTestResult;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_test_results',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        request_id  => { type => 'integer', default => '0', not_null => 1 },
        lab_test_id => { type => 'integer', default => '0', not_null => 1 },
        result      => { type => 'varchar', default => '', length => 255, not_null => 1 },
        time        => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'request_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestLabTestStatu;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_lab_test_status',

    columns => [
        id               => { type => 'serial', not_null => 1 },
        request_id       => { type => 'integer', default => '0', not_null => 1 },
        lab_test_id      => { type => 'integer', default => '0', not_null => 1 },
        status_option_id => { type => 'integer', default => '0', not_null => 1 },
        user_id          => { type => 'integer', default => '0', not_null => 1 },
        time             => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'request_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        status_option => {
            class       => 'LIMS::LabTestStatusOption',
            key_columns => { status_option_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_option',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        option_id  => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'option_id' ],

    foreign_keys => [
        option => {
            class       => 'LIMS::AdditionalOption',
            key_columns => { option_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestPhoneLog;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_phone_log',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        status     => { type => 'enum', check_in => [ 'inbound', 'outbound' ] },
        contact    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        details    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestPrintLog;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_print_log',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestReport;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_report',

    columns => [
        request_id       => { type => 'integer', not_null => 1 },
        comment          => { type => 'text', length => 65535 },
        clinical_details => { type => 'text', length => 65535 },
        status           => { type => 'enum', check_in => [ 'new', 'relapse', 'default' ], default => 'default', not_null => 1 },
        specimen_quality => { type => 'enum', check_in => [ 'good', 'adequate', 'poor' ], default => 'adequate', not_null => 1 },
        diagnosis_id     => { type => 'integer', not_null => 1 },
        created_at       => { type => 'timestamp', not_null => 1 },
        updated_at       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        diagnosis => {
            class       => 'LIMS::Diagnos',
            key_columns => { diagnosis_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestReportHistory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_report_history',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        field      => { type => 'varchar', default => '', length => 255, not_null => 1 },
        content    => { type => 'text', length => 65535 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestResultSummary;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_result_summaries',

    columns => [
        request_id      => { type => 'integer', not_null => 1 },
        lab_section_id  => { type => 'integer', not_null => 1 },
        results_summary => { type => 'text', length => 65535 },
        time            => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestSpecimen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_specimen',

    columns => [
        request_id  => { type => 'integer', not_null => 1 },
        specimen_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'specimen_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        specimen => {
            class       => 'LIMS::Specimen',
            key_columns => { specimen_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestTrial;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_trial',

    columns => [
        request_id => { type => 'integer', not_null => 1 },
        trial_id   => { type => 'integer', default => '0', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },

        trial => {
            class       => 'LIMS::ClinicalTrial',
            key_columns => { trial_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::RequestViewLog;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'request_view_log',

    columns => [
        id         => { type => 'serial', not_null => 1 },
        request_id => { type => 'integer', default => '0', not_null => 1 },
        user_id    => { type => 'integer', default => '0', not_null => 1 },
        ip_address => { type => 'varchar', length => 255, not_null => 1 },
        time       => { type => 'timestamp', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::Request',
            key_columns => { request_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ResultSummaryOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'result_summary_options',

    columns => [
        id             => { type => 'integer', not_null => 1 },
        description    => { type => 'varchar', default => '', length => 255, not_null => 1 },
        lab_section_id => { type => 'integer', default => '0', not_null => 1 },
        is_active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::LabSection',
            key_columns => { lab_section_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::SampleType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'sample_types',

    columns => [
        id            => { type => 'integer', not_null => 1 },
        specimen_type => { type => 'varchar', default => '', length => 50, not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'specimen_type' ],

    relationships => [
        lab_section_sample_type => {
            class      => 'LIMS::LabSectionSampleType',
            column_map => { id => 'sample_type_id' },
            type       => 'one to many',
        },

        specimen_sample_type => {
            class      => 'LIMS::SpecimenSampleType',
            column_map => { id => 'sample_type_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Screen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'screens',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', length => 50 },
        category_id => { type => 'integer', not_null => 1 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ] },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description', 'category_id' ],

    foreign_keys => [
        category => {
            class       => 'LIMS::ScreenCategory',
            key_columns => { category_id => 'id' },
        },
    ],

    relationships => [
        request_initial_screen => {
            class      => 'LIMS::RequestInitialScreen',
            column_map => { id => 'screen_id' },
            type       => 'one to many',
        },

        screen_lab_test => {
            class      => 'LIMS::ScreenLabTest',
            column_map => { id => 'screen_id' },
            type       => 'one to many',
        },

        screen_lab_test_detail => {
            class      => 'LIMS::ScreenLabTestDetail',
            column_map => { id => 'screen_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ScreenCategory;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'screen_category',

    columns => [
        id        => { type => 'integer', not_null => 1 },
        name      => { type => 'varchar', length => 50, not_null => 1 },
        is_active => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    relationships => [
        screens => {
            class      => 'LIMS::Screen',
            column_map => { id => 'category_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ScreenLabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'screen_lab_test',

    columns => [
        screen_id   => { type => 'integer', not_null => 1 },
        lab_test_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'screen_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        screen => {
            class       => 'LIMS::Screen',
            key_columns => { screen_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::ScreenLabTestDetail;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'screen_lab_test_detail',

    columns => [
        screen_id      => { type => 'integer', not_null => 1 },
        lab_section_id => { type => 'integer', not_null => 1 },
        test_details   => { type => 'varchar', default => '', length => 255, not_null => 1 },
    ],

    primary_key_columns => [ 'screen_id', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::LabSection',
            key_columns => { lab_section_id => 'id' },
        },

        screen => {
            class       => 'LIMS::Screen',
            key_columns => { screen_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::Specimen;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'specimens',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        sample_code => { type => 'varchar', length => 4 },
        description => { type => 'varchar', length => 40 },
        active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'sample_code' ],

    relationships => [
        request_specimen => {
            class      => 'LIMS::RequestSpecimen',
            column_map => { id => 'specimen_id' },
            type       => 'one to many',
        },

        specimen_lab_test => {
            class      => 'LIMS::SpecimenLabTest',
            column_map => { id => 'specimen_id' },
            type       => 'one to many',
        },

        specimen_sample_type => {
            class      => 'LIMS::SpecimenSampleType',
            column_map => { id => 'specimen_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::SpecimenLabTest;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'specimen_lab_test',

    columns => [
        specimen_id => { type => 'integer', not_null => 1 },
        lab_test_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'specimen_id', 'lab_test_id' ],

    foreign_keys => [
        lab_test => {
            class       => 'LIMS::LabTest',
            key_columns => { lab_test_id => 'id' },
        },

        specimen => {
            class       => 'LIMS::Specimen',
            key_columns => { specimen_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::SpecimenSampleType;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'specimen_sample_type',

    columns => [
        specimen_id    => { type => 'integer', not_null => 1 },
        sample_type_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'sample_type_id', 'specimen_id' ],

    foreign_keys => [
        sample_type => {
            class       => 'LIMS::SampleType',
            key_columns => { sample_type_id => 'id' },
        },

        specimen => {
            class       => 'LIMS::Specimen',
            key_columns => { specimen_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::StatusOption;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'status_options',

    columns => [
        id          => { type => 'integer', not_null => 1 },
        description => { type => 'varchar', default => '', length => 255, not_null => 1 },
        is_editable => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description' ],

    relationships => [
        requests => {
            class      => 'LIMS::Request',
            column_map => { id => 'status_option_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::User;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'users',

    columns => [
        id               => { type => 'integer', not_null => 1 },
        username         => { type => 'varchar', default => 'username', length => 50, not_null => 1 },
        first_name       => { type => 'varchar', default => 'first_name', length => 50, not_null => 1 },
        last_name        => { type => 'varchar', default => 'last_name', length => 50, not_null => 1 },
        password         => { type => 'varchar', default => 'password', length => 32, not_null => 1 },
        email            => { type => 'varchar', length => 50 },
        user_location_id => { type => 'integer', default => '0', not_null => 1 },
        designation      => { type => 'varchar', default => 'designation', length => 255, not_null => 1 },
        group_id         => { type => 'integer', default => '0', not_null => 1 },
        last_login       => { type => 'timestamp', not_null => 1 },
        active           => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'email' ],
        [ 'first_name', 'last_name' ],
        [ 'username' ],
    ],

    foreign_keys => [
        group => {
            class       => 'LIMS::UserGroup',
            key_columns => { group_id => 'id' },
        },

        user_location => {
            class       => 'LIMS::UserLocation',
            key_columns => { user_location_id => 'id' },
        },
    ],

    relationships => [
        deleted_requests => {
            class      => 'LIMS::DeletedRequest',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        logins => {
            class      => 'LIMS::Login',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        patient_demographic_history => {
            class      => 'LIMS::PatientDemographicHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        patient_edits => {
            class      => 'LIMS::PatientEdit',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_authorisation_diagnosis => {
            class      => 'LIMS::RequestAuthorisationDiagnosi',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_diagnosis_history => {
            class      => 'LIMS::RequestDiagnosisHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_error_code => {
            class      => 'LIMS::RequestErrorCode',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_history => {
            class      => 'LIMS::RequestHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_lab_test_history => {
            class      => 'LIMS::RequestLabTestHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_lab_test_status => {
            class      => 'LIMS::RequestLabTestStatu',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_phone_log => {
            class      => 'LIMS::RequestPhoneLog',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_print_log => {
            class      => 'LIMS::RequestPrintLog',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_report_history => {
            class      => 'LIMS::RequestReportHistory',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        request_view_log => {
            class      => 'LIMS::RequestViewLog',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },

        user_permission => {
            class      => 'LIMS::UserPermission',
            column_map => { id => 'user_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserFunction;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_functions',

    columns => [
        id              => { type => 'integer', not_null => 1 },
        function_name   => { type => 'varchar', length => 20 },
        function_detail => { type => 'varchar', length => 255 },
        active          => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'function_detail' ],
        [ 'function_name' ],
    ],

    relationships => [
        user_group_function => {
            class      => 'LIMS::UserGroupFunction',
            column_map => { id => 'function_id' },
            type       => 'one to many',
        },

        user_permission => {
            class      => 'LIMS::UserPermission',
            column_map => { id => 'function_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserGroup;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_groups',

    columns => [
        id           => { type => 'integer', not_null => 1 },
        group_name   => { type => 'varchar', length => 10 },
        group_label  => { type => 'varchar', length => 30 },
        group_detail => { type => 'varchar', length => 255 },
        active       => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_keys => [
        [ 'group_label' ],
        [ 'group_name' ],
    ],

    relationships => [
        user_group_function => {
            class      => 'LIMS::UserGroupFunction',
            column_map => { id => 'group_id' },
            type       => 'one to many',
        },

        users => {
            class      => 'LIMS::User',
            column_map => { id => 'group_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserGroupFunction;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_group_function',

    columns => [
        group_id    => { type => 'integer', not_null => 1 },
        function_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'group_id', 'function_id' ],

    foreign_keys => [
        function => {
            class       => 'LIMS::UserFunction',
            key_columns => { function_id => 'id' },
        },

        group => {
            class       => 'LIMS::UserGroup',
            key_columns => { group_id => 'id' },
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserLocation;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_locations',

    columns => [
        id            => { type => 'integer', not_null => 1 },
        location_name => { type => 'varchar', default => '', length => 50, not_null => 1 },
        region_code   => { type => 'varchar', length => 5 },
        active        => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes' },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'location_name' ],

    foreign_keys => [
        parent_organisation => {
            class       => 'LIMS::ParentOrganisation',
            key_columns => { region_code => 'parent_code' },
        },
    ],

    relationships => [
        users => {
            class      => 'LIMS::User',
            column_map => { id => 'user_location_id' },
            type       => 'one to many',
        },
    ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserMessage;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_message',

    columns => [
        id           => { type => 'serial', not_null => 1 },
        recipient_id => { type => 'integer', default => '0', not_null => 1 },
        sender_id    => { type => 'integer', default => '0', not_null => 1 },
        message      => { type => 'text', length => 65535, not_null => 1 },
        received     => { type => 'timestamp', not_null => 1 },
        acknowledged => { type => 'timestamp' },
    ],

    primary_key_columns => [ 'id' ],
);

1;

#---------------------------------------------------------------------------
package LIMS::UserPermission;

use strict;

use base qw(LIMS::DB::Object::AutoBase1);

__PACKAGE__->meta->setup(
    table   => 'user_permission',

    columns => [
        user_id     => { type => 'integer', not_null => 1 },
        function_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'user_id', 'function_id' ],

    foreign_keys => [
        function => {
            class       => 'LIMS::UserFunction',
            key_columns => { function_id => 'id' },
        },

        user => {
            class       => 'LIMS::User',
            key_columns => { user_id => 'id' },
        },
    ],
);

1;

