#
#===============================================================================
#
#  DESCRIPTION:
#
#===============================================================================

package TestsFor::LIMS::Local::IssueTracker;
use Test::Class::Moose;
use DDP;
use Try::Tiny;

use lib  'script/prereq_lib'; # make sure we are using old HTTP::Tiny


with 'Test::Class::Moose::Role::AutoUse';

use YAML::Tiny;
use FindBin qw($RealBin);

sub test_some : Tests {
    my $test  = shift;
    my $class = $test->test_class;
    my @card_ids;
    my @lists;

    my $trello;

    {
        # _BUILD_CONFIG dies - corrupted yaml
        throws_ok {
            $trello =
              LIMS::Local::IssueTracker->new( config_file =>
                  "$RealBin/config/settings/.leeds/issue_tracking_malformed.yml"
              );
        }
        qr/(failed to classify line|undefined value as an ARRAY reference)/,
          "died with YAML error";

        # CHECK_CONFIG dies - yaml without required key
        throws_ok{
            $trello = LIMS::Local::IssueTracker->new( config_file =>
                    "$RealBin/config/settings/.leeds/issue_tracking_missing.yml" );
        } qr/config error/, "died with the config error";

        # correct yaml
        lives_ok {
            $trello = LIMS::Local::IssueTracker->new( config_file =>
                  "$RealBin/../config/settings/.leeds/issue_tracking.yml" );
        }
        "correct yaml file. Plugin loaded.";

        isa_ok $trello , "LIMS::Local::IssueTracker", "Is an LIMS::Local::IssueTracker object";

        ok( $trello->does('MooseX::Object::Pluggable'), "does Pluggable" );
        ok( $trello->does('LIMS::Local::Role::Trackable'), "does Trackable" );

        my $plugin = $trello->config->{plugin};
        is $plugin, "Trello", "config set for trello";

    }

    {
       # plugin has create_issue method
        ok $trello->can("create_issue"), "can create RFC";

       # dies if given an invailid 'reason'
        throws_ok {
            $trello->create_issue(
                {
                    name   => "fail",
                    desc   => "fail description",
                    reason => "invalid reason"
                }
            );
        } qr/Trello error adding label/,
           "died with the Trello error";

        # create issues with all possible reasons
        while ( my ( $key, $value ) = each %{ $trello->config->{colours} } ) {
            my $args = { name => $value, desc => "test1 description", reason => $key };
            my $res = $trello->create_issue($args);

            is length($res), 24, "http status OK";
            push @card_ids, $res;

        # move the cards around a bit
            if ( ( scalar @card_ids % 2 ) == 0 ) {
                my $to_list =
                    ( scalar @card_ids % 4 ) == 0
                    ? "complete"
                    : "rejected";
                $trello->move_card( $res, $to_list );
                my $card_status = $trello->get_status($res);
                like $card_status , qr/Completed|Rejected/,
                     "card $res in $card_status";

        #is $card_status , "Backlog", "card $res in Backlog";
            }
            else {
                my $card_status = $trello->get_status($res);
                is $card_status , "Backlog", "card $res in Backlog";
            }
        }
    }
    {
# handle stale or incorrect card id
        my $res = "blahblahblah";
        throws_ok {
        my $card_status = $trello->get_status($res);
        } qr/Trello error: can't get card/,
           "died with the *can't get card* error";
    }
    {
        # tests to die when moving cards
        throws_ok {$trello->move_card( "id")} qr/requires destination/, "move without destination";
        throws_ok {$trello->move_card( "badid" , "complete")} qr/can't move card badid/, "move with bad id";
    }

    {
        # now take list of card_ids and ask which are in complete or rejected lists

        my $complete_ids = $trello->list_complete( \@card_ids );
        my $rejected_ids = $trello->list_rejected( \@card_ids );

        is scalar @{$complete_ids}, 1, "1 card in completed";
        is scalar @{$rejected_ids}, 1, "1 card in rejected";
    }
    try {

        # tidy up test board
        $trello->archive_issues($_) for qw/new complete rejected/;

    }
    finally {ok !$@, "Archive test lists";}

}

1;

