#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;
# use HTML::TreeBuilder;
use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 14; # use Test::More 'no_plan';

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# need to drop & re-create following tables:
foreach ( qw/clinical_trials/ ) {
    drop_and_recreate($_);
}

$mech->get_ok('/config/trials');         # print_and_exit();

### check title:
$mech->content_contains(
    'Admin &raquo; Clinical Trials',
    'title matches',
);                                     # print_and_exit();

# add 2 trials:
{
    my $trial_name = 'NCRI Myeloma X';
    
    $mech->field('trial_name', $trial_name);
    $mech->submit_form();                 # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!value="$trial_name"!,
        'new entry value correct',
    );                                    # print_and_exit();
}

{
    my $trial_name = 'HMDS Community monitoring';
    
    $mech->field('trial_name', $trial_name);
    $mech->submit_form();                  # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!value="$trial_name"!,
        'new entry value correct',
    );                                    # print_and_exit();
}

# edit 2nd entry:
$mech->get_ok('/config/trials/edit/2');    # print_and_exit();

{
    my $old_term = 'HMDS Community monitoring';
    my $new_term = 'HMDS outreach';
    
    $mech->field('trial_name',$new_term);
    $mech->submit_form();                # print_and_exit();
    
    ### check section found:
    $mech->content_contains(
        qq!value="$new_term"!,
        'new entry value correct',
    );                                   # print_and_exit();  

    ### check section found:
    $mech->content_lacks(
        qq!value="$old_term"!,
        'previous entry value not detected',
    );                                     # print_and_exit();
}

# inactivate 1st entry:
{
    # 1st check for absence of inactive record:
    $mech->content_lacks(
        qq!<option value="no" selected>!,
        'OK: inactive record detected',
    );                                  # print_and_exit();

    # select 2nd 'Edit' link:
    $mech->follow_link(text => 'Edit', n => 2 );        # print_and_exit();
    
    # check for correct entry:
    $mech->content_contains(
        qq!value="NCRI Myeloma X"!,
        'OK: correct entry loaded',
    );                                   # print_and_exit();
    
    $mech->field('active', 'No');
    $mech->submit_form();                        # print_and_exit();

    # now check for presence of inactive flag (not specific to this records, but there's only 2):
    $mech->content_contains(
        qq!<option value="no" selected>!,
        'OK: inactive record detected',
    );                                   # print_and_exit();  
}

# do_logout(); logout link not available for admin function