package LIMS::DB::LabTestResultDataType;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_test_result_data_types',

    columns => [
        id          => { type => 'serial', not_null => 1 },
        description => { type => 'varchar', length => 25, not_null => 1 },
        is_active   => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => 'description',
    
    relationships => [
        lab_test_data_type => {
            class      => 'LIMS::DB::LabTestDataType',
            column_map => { id => 'data_type_id' },
            type       => 'one to many',
        },

        lab_test_result_option => {
            class      => 'LIMS::DB::LabTestResultOption',
            column_map => { id => 'data_type_id' },
            type       => 'one to many',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_test_result_data_types');

1;