package LIMS::DB::RequestReport;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    # # view allows new request_specimen_detail & request_report_detail 'vertical'
    # tables to still be accessed through reqeust_report object:
    table => 'request_report_view', # 'request_report'

    columns => [ # read-only view so don't need NULL/NOT NULL
        request_id        => { type => 'integer' },
        comment           => { type => 'text', length => 65535 },
        morphology        => { type => 'text', length => 65535 },
        clinical_details  => { type => 'text', length => 65535 },
        gross_description => { type => 'text', length => 65535 },
        status            => {
            type => 'enum', check_in => [ 'new', 'relapse', 'default' ],
            default  => 'default', not_null => 1,
        },
        biopsy_site      => { type => 'text', length => 65535 },
        specimen_quality => {
            type => 'enum', check_in => [ 'good', 'adequate', 'poor' ],
            default  => 'adequate', not_null => 1,
        },
        specimen_date    => { type => 'datetime' },
        diagnosis_id     => { type => 'integer' },
        updated_at       => { type => 'timestamp' },
        created_at       => { type => 'timestamp' },
    ],

    primary_key_columns => [ 'request_id' ],

    foreign_keys => [
        diagnosis => {
            class       => 'LIMS::DB::Diagnosis',
            key_columns => { diagnosis_id => 'id' },
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('request_report');

1;
