package LIMS::DB::PatientNote;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'patient_notes',

    columns => [
        patient_id => { type => 'integer', not_null => 1 },
        detail     => { type => 'text', length => 65535, not_null => 1 },
    ],

    primary_key_columns => [ 'patient_id' ],
    
    foreign_keys => [
        patient => {
            class       => 'LIMS::DB::Patient',
            key_columns => { patient_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('patient_notes');

1;
