package LIMS::DB::Outreach::RequestClinicReturn;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',

    table   => 'request_clinic_return',

    columns => [
        request_id       => { type => 'integer', not_null => 1 },
        appointment_date => { type => 'date', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id' ],

    relationships => [
        follow_up => {
            class      => 'LIMS::DB::Outreach::RequestFollowup',
            column_map => { request_id => 'request_id' },
            type       => 'one to one',
        }
    ],
);

__PACKAGE__->meta->make_manager_class('request_clinic_returns');

1;