package LIMS::DB::Outreach::QuestionnairePain;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    schema  => 'outreach',
    
    table   => 'questionnaire_pain',
    
    columns => [
        request_id     => { type => 'integer', not_null => 1 },
        pain_option_id => { type => 'integer', not_null => 1 },
    ],

    primary_key_columns => [ 'request_id', 'pain_option_id' ],

    foreign_keys => [
        pain_option => {
            class       => 'LIMS::DB::Outreach::PainOption',
            key_columns => { pain_option_id => 'id' },
        },
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('questionnaire_pain');

1;
