
#===============================================================================
# run create_core_data.sh in setup dir against recent db clone & 'git push origin'
# on deployment server, 'git pull origin' and run this script with '-c' arg and
# optional --no-data to skip core_data entry
# create config/settings/.<centre> dir with idle_timeout.yml & local_addr.yml
# create config/settings/<centre>.txt & css/local/<centre>.css
# symlink resources/menu/local/request_forms & file_uploads
# new init.d/lims_fastcgi_<centre>; add <centre> to init.d/restart-lims
# configure fastcgi socket in apache2/default & Alias in apache2/default-ssl
# ensure 'view' definer user exists in users table eg raj@localhost vs raj@%
#===============================================================================

use FindBin qw($Bin);
use Modern::Perl;
use Getopt::Long;
use Config::Auto;
use Data::Dumper;
use DBI;

my $skip_data = 0; # optional flag
my $db_name;       # required
GetOptions (
    "centre|c=s" => \$db_name,    # string
    "no-data"    => \$skip_data,  # flag
) or die("Error in command line arguments\n"); # warn $skip_data;
$db_name || die 'name of db to drop & re-create is required'; # warn $db_name; exit;

print "WARNING: db '$db_name' will be dropped & re-created. Type 'yes' to proceed ... ";
chomp( my $ok = <STDIN> ); # say $ok;
unless ( $ok eq 'yes' ) {
    say 'aborting';
    exit;
} # say 'proceeding'; exit;

my $src  = "$Bin/../setup/core_data.gz"; # data source
# change name of central lab in new_centre.sql:
my $sql  = "$Bin/../setup/new_centre.sql"; # minimum data set (user = raj; etc)
my $dsn  = 'dbi:mysql:hilis4';
my $zcat = '/bin/zcat';

use vars qw($SQL_FOR_TABLE $FOREIGN_KEYS $VIEWS);
require "$Bin/../setup/lims.sql"; # provides $SQL_FOR_TABLE & $FOREIGN_KEYS

use lib "$Bin/../lib"; # warn $Bin; exit; # for Config::Auto to find L::L::Utils
my $cfg = Config::Auto::parse("$Bin/../config/lims_config.pl", format => 'perl');
# warn Dumper $cfg; # exit;

my $admin_user = $cfg->{settings}{admin_db_user}; # warn $admin_user;
my $admin_pwd  = $cfg->{settings}{admin_db_pwd};  # warn $admin_pwd;

my $dbh = DBI->connect(
	$dsn, $admin_user, $admin_pwd, # views need SUPER priviledges
	{ RaiseError => 1, PrintError => 0 }
);

$dbh->do($_) for (
    qq!DROP DATABASE IF EXISTS `$db_name`!,
    qq!CREATE DATABASE `$db_name`!,
    qq!USE `$db_name`!,
);

# tables (not views):
print "tables: ...............................\n";
foreach ( sort keys %$SQL_FOR_TABLE ) { # skip views - need all tables to exist:
    # next if $_ =~ /_view\Z/; # moved to own section
    print $_, "\n";
    $dbh->do( qq!DROP TABLE IF EXISTS $_! );
    $dbh->do( $SQL_FOR_TABLE->{$_} );
}
# views:
print "views: ...............................\n";
foreach ( sort keys %$VIEWS ) {  # do views last:
    # next unless $_ =~ /_view\Z/; # in own section now
    print $_, "\n";
    $dbh->do( qq!DROP VIEW IF EXISTS $_! );
    $dbh->do( $VIEWS->{$_} );
}
# FK's:
print "foreign keys: ...............................\n";
foreach my $fk( sort keys %$FOREIGN_KEYS ) {  print $fk, "\n";
    $dbh->do($FOREIGN_KEYS->{$fk});
}

$dbh->disconnect;

# data:
if ( $skip_data ) {
    say 'skipping core data entry';
}
else {
    print "data: ...............................\n";
    system "$zcat $src | mysql $db_name -u $admin_user -p$admin_pwd";
    system "mysql -u $admin_user -p$admin_pwd $db_name < $sql";
}
