package LIMS::DB::LabTestDataType;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'lab_test_data_type',

    columns => [
        lab_test_id  => { type => 'integer', default => '0', not_null => 1 },
        data_type_id => { type => 'integer', default => '0', not_null => 1 },
        is_active    => { type => 'enum', check_in => [ 'yes', 'no' ], not_null => 1 },
    ],

    primary_key_columns => [ 'lab_test_id' ],

    foreign_keys => [
        data_type => {
            class       => 'LIMS::DB::LabTestResultDataType',
            key_columns => { data_type_id => 'id' },
        },
        lab_test => {
            class       => 'LIMS::DB::LabTest',
            key_columns => { lab_test_id => 'id' },
        },
    ],
);

__PACKAGE__->meta->make_manager_class('lab_test_data_type');

1;