#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;

use strict;
use warnings;

use Test::More tests => 19;
# use Test::More 'no_plan';

=begin: tests:
=cut

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

do_login();

my $dbix = get_dbix();

{ # register lab_test # 44:
    my %args = (
        id => 44, # to match config file
        test_name => 'rq_cml',
        field_label => 'CML RQ',
        lab_section_id => 3,
        test_type => 'panel',
        has_results => 'no',
    );
    $dbix->insert( 'lab_tests', \%args );
}
{ # register lab_test # 263:
    my %args = (
        id => 263, # to match config file
        test_name => 'rna_extraction',
        field_label => 'RNA extraction',
        lab_section_id => 3,
        test_type => 'test',
        has_results => 'no',
    );
    $dbix->insert( 'lab_tests', \%args );
}
{ # lab_test_sample_type:
	my $sample_type_ids = $dbix->select('lab_section_sample_type',
		['sample_type_id'], { lab_section_id => 3 } )->flat; # warn Dumper $sample_type_ids;

	for my $id (44,263) {
		$dbix->insert('lab_test_sample_type',
			{ lab_test_id => $id, sample_type_id => $_ }) for @$sample_type_ids;
	}
}
{ # screen:
    my %args = (
        description => 'Follow-up CML (PB)',
        category_id => 1,
        active => 'yes',
    );
    $dbix->insert( 'screens', \%args );
}
{ # screen_lab_tests:
    for (44, 263) {
        my %args = (
            screen_id => 3,
            lab_test_id => $_,
        );
        $dbix->insert( 'screen_lab_test', \%args );
    }
}
{ # diagnosis:
    my %args = (
        name => 'Chronic myeloid leukaemia - major molecular response',
        diagnostic_category_id => 1,
        icdo3 => '9875/3',
        active => 'yes',
    );
    $dbix->insert( 'diagnoses', \%args );
}
{ # change specimen type to PB for requests 1 & 2 to allow auto-report:
    $dbix->delete('request_specimen', { specimen_id => 4} ); # delete BMAT
    $dbix->update('request_specimen', { specimen_id => 1 }, { specimen_id => 2 });
}
{ # change year of requests 1 & 2 to match xl data file:
    $dbix->update('requests', { year => 2012 });
}
# screen requests 1 & 2 the quick way:
$mech->get_ok('/screen/do_initial_screen/1?screen_id=3;option_id=1');
$mech->get_ok('/screen/do_initial_screen/2?screen_id=3;option_id=1');

$mech->get_ok( '/data-import/bcr_abl' );
$mech->submit_form(
    fields => { source => './t/bcr-abl.xls' }
);                                                            # print_and_exit();

{ # warn $mech->content(); exit;
    $mech->content_contains(
       '1/12::1::45035::9::0.012', 'OK: calculated result [1] found', # adjusted for IS
    );
    $mech->content_contains(
        '2/12::2::42064::0::0', 'OK: calculated result [2] found',
    );                                                        # print_and_exit();
}
{ # submit both results:
    $mech->form_name('bcr_abl');

    $mech->tick('result', '1/12::1::45035::9::0.012', 1); # adjusted for IS
    $mech->tick('result', '2/12::2::42064::0::0',     1);
    $mech->submit();                                         # print_and_exit();
}
{
    $mech->has_tag_like(
        td => 'BCR-ABL transcription number = 9',
        'OK: calculated result found',
    );
    $mech->has_tag_like(
        td => 'BCR-ABL transcription number = 0',
        'OK: calculated result found',
    );
}
{ # get history:
    $mech->get_ok('/history/=/1');                           # print_and_exit();
    $mech->has_tag_like(
        td => 'new Molecular result summary',
        'OK: expected history found',
    );
    $mech->has_tag_like(
        td => 'set CML RQ status to complete',
        'OK: expected history found',
    );
    $mech->has_tag_like(
        td => 'reported',
        'OK: expected history found',
    );                                                       # print_and_exit();

    $mech->get_ok('/history/=/2');                           # print_and_exit();
    $mech->has_tag_like(
        td => 'new Molecular result summary',
        'OK: expected history found',
    );
    $mech->has_tag_like(
        td => 'set CML RQ status to complete',
        'OK: expected history found',
    );
    $mech->has_tag_like(
        td => 'reported',
        'OK: expected history found',
    );
}
