#!/usr/bin/perl

use Test::WWW::Mechanize::CGIApp;

use Data::Dumper;

use strict;
use warnings;

use Test::More tests => 21; # use Test::More 'no_plan';

BEGIN {
    require 't/test-lib.pl';
}

my $mech = get_mech();

do_login();

my $dbh;

eval {
    $dbh = get_dbh() or die 'no database handle recieved from get_dbh';
};

warn $@ if $@;

# insert new clinician:
$mech->get_ok('/config/clinicians');                          # print_and_exit();

$mech->content_contains(
    'Admin &raquo; Clinicians',
    'OK: config clinicians page loaded',
);

my %clinician = (
    national_code => undef, # triggers 'missing' error
    surname => 'brown',
    initials_1 => 'a',
    initials_2 => 'b',
    referral_source_id => 1,
    hospital_department_code => 823,
    _display_name => 'Bradford',
);
$mech->submit_form(
    fields => \%clinician,
);                                                            # print_and_exit();

# missing field error:
has_dfv_errors();
has_missing();

$clinician{national_code} = 'c 0123456';

$mech->submit_form(
    fields => \%clinician,
);

# invalid field error:
has_dfv_errors();                                             # print_and_exit();
has_invalid(); 

$clinician{national_code} = '0123456';
$clinician{prefix} = 'C';

# submit valid data:
$mech->submit_form(
    fields => \%clinician,

);                                                            # print_and_exit();

# entry successful:
$mech->content_contains(
    get_messages('admin')->{clinician}->{create_success},
    'OK: form entry success',
);                                                             # print_and_exit();

# insert another clinician with same code but different surname:
$mech->get_ok('/config/clinicians');                          # print_and_exit();

$clinician{surname} = 'green';

$mech->submit_form(
    fields => \%clinician,
);                                                            # print_and_exit();

# surname mismatch error:
$mech->content_contains(
    ( sprintf get_messages('admin')->{clinician}->{name_mismatch},
       uc 'c'.$clinician{national_code}, 'Brown AB' ),
    'OK: surname mis-match detected',
);                                                            # print_and_exit();

# correct surname & re-submit:
$clinician{surname} = 'brown';

$mech->submit_form(
    fields => \%clinician,
);                                                            # print_and_exit();

# duplicate clinician/location error:
$mech->content_contains(
    get_messages('admin')->{clinician}->{not_unique},
    'OK: duplicate clinician/location detected',
);                                                            # print_and_exit();

# load GP's page:
$mech->get_ok('/config/general-practitioners');               # print_and_exit();
{
    # retrieve all:
    retrieve_all_records('find_referrer','name');             # print_and_exit();
    
    my $i=0;
    foreach ( 'G1234567', 'OLD SURGERY, NT1 1TN', 'Black DE', 'yes' ) {
        $i++; 
        $mech->content_contains(
            qq!value="$_"!,
            "OK: GP field [$i] detected",
        );
    }
}

# follow 'edit' link:
$mech->follow_link_ok(
    # {n => 8}, "Logout $_ via eighth link on page",
    { url_regex => qr/edit/i, },
    'OK: select "edit" link',
);                                                            # print_and_exit();

$mech->submit_form(
    fields => {
        active => 'no',
    }
);                                                            # print_and_exit();

# retrieve all:
retrieve_all_records('find_referrer','name');                 # print_and_exit();

$mech->content_contains(
    qq!value="no"!,
    "OK: changed field detected",
);

# do_logout(); logout link not available for admin function
