#!/usr/bin/env perl

# Dancer2 fileuploader

# essential to set DANCER_ENVIRONMENT before calling D2 or defaults to development
BEGIN {
	$ENV{DANCER_APPHANDLER} = 'PSGI';
	$ENV{DANCER_ENVIRONMENT} = $ENV{PLACK_ENV} = 'production';
}

# for development debugging:
BEGIN {
	use lib (
		'/home/raj/perl5/lib/perl5',
		'/home/raj/apps/FileUploader-D2/lib',
	);
	use autodie;
	close STDERR;
	open STDERR, '>>', '/home/raj/apps/FileUploader-D2/logs/debug.txt'; # doesn't record 'die' events
}

use Dancer2 0.2;
use Plack::Runner;

# For some reason Apache SetEnv directives dont propagate
# correctly to the dispatchers, so forcing PSGI and env here
# is safer.
set apphandler => 'PSGI';
set environment => 'production'; # doesn't work - set in BEGIN block above

my $psgi = '/home/raj/apps/FileUploader-D2/bin/app.psgi';
die "Unable to read startup script: $psgi" unless -r $psgi;

Plack::Runner->run($psgi);
