package LIMS::DB::ResultSummaryOption;

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table   => 'result_summary_options',

    columns => [
        id             => { type => 'serial', not_null => 1 },
        description    => { type => 'varchar', length => 255, not_null => 1 },
        lab_section_id => { type => 'integer', default => '0', not_null => 1 },
        is_active      => { type => 'enum', check_in => [ 'yes', 'no' ], default => 'yes', not_null => 1 },
    ],

    primary_key_columns => [ 'id' ],

    unique_key => [ 'description', 'lab_section_id' ],

    foreign_keys => [
        lab_section => {
            class       => 'LIMS::DB::LabSection',
            key_columns => { lab_section_id => 'id' },
        },
    ],
    relationships => [
            result_summary_expansion => {
                class      => 'LIMS::DB::ResultSummaryExpansion',
                column_map => { id => 'result_summary_option_id' },
                type       => 'one to one',
        },
    ],
);

__PACKAGE__->meta->make_manager_class('result_summary_options');

1;
