package LIMS::DB::RequestStorageView;

# exists to map Genomics vialId to request via request_storage & request_lab_test_results tables

use strict;

use base qw(LIMS::RDBO);

__PACKAGE__->meta->setup(
    table => 'request_storage_view',

    columns => [
        vialId     => { type => 'varchar' }, # read-only view so only need  minimal defs
        request_id => { type => 'integer' },
    ],

    primary_key_columns => [ 'vialId' ],

    foreign_keys => [
        request => {
            class       => 'LIMS::DB::Request',
            key_columns => { request_id => 'id' },
            rel_type    => 'one to one',
        },
    ],
);

# __PACKAGE__->meta->make_manager_class('request_storage_view'); # don't need it

1;
