package LIMS::Controller::Roles::LocationSearch;

use strict;
use Moose::Role;

#-------------------------------------------------------------------------------
sub referral_source_search {
    my $self = shift;
    
	my $dfv = $self->check_rm('default', $self->validate('referral_source_search') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param
    
    my $search_terms = $self->generate_search_constraints($data)
    || return $self->forward('default'); # protect against submission of empty form

    my $total_count = $self->model('ReferralSource')
		->get_referral_sources_count($search_terms);
    #  $self->debug($total_count);
	
    # zero hits, or too many to handle:
    if (! $total_count || $total_count > 1000 ) {
        $self->stash->{status_msg} = $total_count ?
            sprintf $self->messages('search')->{too_many_records}, $total_count
                : $self->messages('search')->{no_records_found};

        my $html = $self->forward('default');
        return $self->fill_form($html);
    }

    my %args_for_search = (
		sort_by => $self->query->param('sort_by') || 'display_name',
	);
	
    if ( $total_count > $self->cfg('settings')->{entries_per_page} ) {
        # invoke pager for template and add limit & offset params to \%args:
        $self->pager({ query => \%args_for_search, total => $total_count });
    }
	
	my $sources = $self->model('ReferralSource')
		->get_referral_sources($search_terms, \%args_for_search);
	
	$self->tt_params( sources => $sources );
	
	return $self->tt_process;
}

#-------------------------------------------------------------------------------
sub parent_organisation_search {
    my $self = shift;
    
	my $dfv = $self->check_rm('default', $self->validate('parent_organisation_search') )
	|| return $self->dfv_error_page;

    my $data = $dfv->valid
    || return $self->forward('default'); # eg if empty param
    
    my $search_terms = $self->generate_search_constraints($data)
    || return $self->forward('default'); # protect against submission of empty form

    my $total_count = $self->model('ReferralSource')
		->get_parent_organisations_count($search_terms);
    #  $self->debug($total_count);
	
    # zero hits, or too many to handle:
    if (! $total_count || $total_count > 1000 ) {
        $self->stash->{status_msg} = $total_count ?
            sprintf $self->messages('search')->{too_many_records}, $total_count
                : $self->messages('search')->{no_records_found};

        my $html = $self->forward('default');
        return $self->fill_form($html);
    }

    my %args_for_search = (
		sort_by => $self->query->param('sort_by') || 'description',
	);
	
    if ( $total_count > $self->cfg('settings')->{entries_per_page} ) {
        # invoke pager for template and add limit & offset params to \%args:
        $self->pager({ query => \%args_for_search, total => $total_count });
    }
	
	my $parents = $self->model('ReferralSource')
		->get_parent_organisations($search_terms, \%args_for_search);
	
	$self->tt_params( parents => $parents );
	
	return $self->tt_process;
}

=begin # using referrer_department.parent_organisation rel in model now
sub _get_address_map {
    my $self = shift;
    my $referrers = shift;

    # get list of referrer.id's from referrers object:
    my @referrer_ids = map { $_->id } @$referrers; # DEBUG \@request_ids;

	my $referrer_departments
		= $self->model('Referrer')->get_practice_addresses(\@referrer_ids);
	
    # create address_map of keys = referrer_id, vals = parent_org.description
    my %address_map;
    foreach my $r( @{ $referrer_departments } ) {
		my $referrer_id = $r->referrer_id;
        my $address  = $r->parent_organisation->description;
		$address_map{$referrer_id} = $address;
    }

    return \%address_map;
}
=cut

1;